/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeNames;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.DependencyCardinality;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceRegistryException;
import io.helidon.service.registry.ServiceSupplies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class Bindings {
    private static final ResolvedType OBJECT = ResolvedType.create(TypeNames.OBJECT);
    private final Map<ResolvedType, List<DependencyBinding>> bindingsByContract = new HashMap<ResolvedType, List<DependencyBinding>>();
    private final Map<ServiceInfo, ServiceBindingPlan> bindingPlans = new IdentityHashMap<ServiceInfo, ServiceBindingPlan>();
    private final ReentrantLock lock = new ReentrantLock();
    private final CoreServiceRegistry registry;

    Bindings(CoreServiceRegistry registry) {
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(ServiceInfo serviceInfo) {
        this.lock.lock();
        try {
            ServiceBindingPlan bindingPlan = new ServiceBindingPlan(this.registry, serviceInfo);
            this.bindingPlans.put(serviceInfo, bindingPlan);
            for (DependencyBinding binding : bindingPlan.allBindings()) {
                this.bindingsByContract.computeIfAbsent(ResolvedType.create(binding.dependency.contract()), it -> new ArrayList()).add(binding);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void forgetContract(ResolvedType type2) {
        this.lock.lock();
        try {
            this.forgetBindingForContract(type2);
            this.forgetBindingForContract(OBJECT);
        }
        finally {
            this.lock.unlock();
        }
    }

    ServiceBindingPlan bindingPlan(ServiceInfo service) {
        if (service.dependencies().isEmpty()) {
            return new ServiceBindingPlan(this.registry, service);
        }
        ServiceBindingPlan bindingPlan = this.bindingPlans.get(service);
        if (bindingPlan == null) {
            throw new ServiceRegistryException("An attempt to get binding plan for service that was not discovered: " + String.valueOf(service.serviceType()));
        }
        return bindingPlan;
    }

    boolean isValidContract(ResolvedType type2) {
        return this.bindingsByContract.containsKey(type2) || this.bindingsByContract.containsKey(OBJECT);
    }

    private void forgetBindingForContract(ResolvedType type2) {
        List<DependencyBinding> toRemove = this.bindingsByContract.get(type2);
        if (toRemove == null) {
            return;
        }
        toRemove.forEach(DependencyBinding::clear);
    }

    static class ServiceBindingPlan {
        private final Map<Dependency, DependencyBinding> bindingPlan = new HashMap<Dependency, DependencyBinding>();
        private final ServiceInfo serviceInfo;
        private final CoreServiceRegistry registry;

        ServiceBindingPlan(CoreServiceRegistry registry, ServiceInfo serviceInfo) {
            this.serviceInfo = serviceInfo;
            this.registry = registry;
            this.createBindings();
        }

        void ensure() {
            for (Dependency dependency : this.serviceInfo.dependencies()) {
                this.bindingPlan.get(dependency).instanceSupply();
            }
        }

        Collection<DependencyBinding> allBindings() {
            return this.bindingPlan.values();
        }

        DependencyBinding binding(Dependency dependency) {
            return this.bindingPlan.get(dependency);
        }

        private void createBindings() {
            for (Dependency dependency : this.serviceInfo.dependencies()) {
                this.bindingPlan.put(dependency, new DependencyBinding(this.registry, this.serviceInfo, dependency));
            }
        }
    }

    static class DependencyBinding {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final CoreServiceRegistry registry;
        private final ServiceInfo serviceInfo;
        private final Dependency dependency;
        private final Lookup lookup;
        private boolean bound;
        private List<ServiceInfo> serviceInfos;
        private Supplier<Object> instanceSupply;

        private DependencyBinding(CoreServiceRegistry registry, ServiceInfo serviceInfo, Dependency dependency) {
            this.registry = registry;
            this.serviceInfo = serviceInfo;
            this.dependency = dependency;
            this.lookup = ((Lookup.Builder)Lookup.builder().dependency(dependency)).update(it -> {
                if (serviceInfo.contracts().contains(ResolvedType.create(dependency.contract())) && serviceInfo.qualifiers().containsAll(dependency.qualifiers())) {
                    it.weight(serviceInfo.weight());
                }
            }).build();
        }

        List<ServiceInfo> descriptors() {
            return this.serviceInfos;
        }

        Dependency dependency() {
            return this.dependency;
        }

        void bind(List<ServiceInfo> serviceInfos) {
            this.lock.writeLock().lock();
            try {
                this.bound = true;
                this.serviceInfos = serviceInfos;
                this.createInstanceSupply();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        Supplier<Object> instanceSupply() {
            this.lock.readLock().lock();
            try {
                if (this.bound) {
                    Supplier<Object> supplier = this.instanceSupply;
                    return supplier;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                if (this.bound) {
                    Supplier<Object> supplier = this.instanceSupply;
                    return supplier;
                }
                this.bound = true;
                this.discoverBinding();
                this.createInstanceSupply();
                Supplier<Object> supplier = this.instanceSupply;
                return supplier;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        void clear() {
            this.lock.writeLock().lock();
            try {
                this.bound = false;
                this.serviceInfos = null;
                this.instanceSupply = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private void createInstanceSupply() {
            if (this.dependency.isServiceInstance()) {
                this.createInstanceSupplyServiceInstance();
            } else {
                this.createInstanceSupplyDirectContract();
            }
            if (this.dependency.isSupplier()) {
                this.instanceSupply = new DependencySupplier(this.dependency, this.instanceSupply);
            }
        }

        private void createInstanceSupplyDirectContract() {
            this.instanceSupply = switch (this.dependency.cardinality()) {
                default -> throw new MatchException(null, null);
                case DependencyCardinality.REQUIRED -> new ServiceSupplies.ServiceSupply(this.lookup, this.managers(this.serviceInfos));
                case DependencyCardinality.OPTIONAL -> new ServiceSupplies.ServiceSupplyOptional(this.lookup, this.managers(this.serviceInfos));
                case DependencyCardinality.LIST -> new ServiceSupplies.ServiceSupplyList(this.lookup, this.managers(this.serviceInfos));
            };
        }

        private void createInstanceSupplyServiceInstance() {
            this.instanceSupply = switch (this.dependency.cardinality()) {
                default -> throw new MatchException(null, null);
                case DependencyCardinality.REQUIRED -> new ServiceSupplies.ServiceInstanceSupply(this.lookup, this.managers(this.serviceInfos));
                case DependencyCardinality.OPTIONAL -> new ServiceSupplies.ServiceInstanceSupplyOptional(this.lookup, this.managers(this.serviceInfos));
                case DependencyCardinality.LIST -> new ServiceSupplies.ServiceInstanceSupplyList(this.lookup, this.managers(this.serviceInfos));
            };
        }

        private List managers(List<ServiceInfo> serviceInfos) {
            return serviceInfos.stream().map(this.registry::serviceManager).collect(Collectors.toUnmodifiableList());
        }

        private void discoverBinding() {
            this.serviceInfos = this.registry.lookupServices(this.lookup).stream().filter(it -> it != this.serviceInfo).collect(Collectors.toList());
        }

        private static class DependencySupplier
        implements Supplier<Object> {
            private final Dependency dependency;
            private final Supplier<Object> instanceSupply;

            DependencySupplier(Dependency dependency, Supplier<Object> instanceSupply) {
                this.dependency = dependency;
                this.instanceSupply = instanceSupply;
            }

            @Override
            public Object get() {
                return this.instanceSupply;
            }

            public String toString() {
                return "DependencySupplier for " + String.valueOf(this.dependency) + ", supply: " + String.valueOf(this.instanceSupply);
            }
        }
    }
}

