/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.service.registry.ActivationPhase;
import io.helidon.service.registry.ActivationResultBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.service.registry.ActivationResultBlueprint")
public interface ActivationResult
extends ActivationResultBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ActivationResult instance) {
        return (Builder)ActivationResult.builder().from(instance);
    }

    public static ActivationResult create() {
        return ActivationResult.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ActivationResult>
    implements io.helidon.common.Builder<Builder, ActivationResult> {
        private Builder() {
        }

        @Override
        public ActivationResult buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ActivationResultImpl(this);
        }

        @Override
        public ActivationResult build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ActivationResult>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private ActivationPhase finishingActivationPhase;
        private ActivationPhase startingActivationPhase = ActivationPhase.INIT;
        private ActivationPhase targetActivationPhase = ActivationPhase.INIT;
        private boolean success;
        private Throwable error;

        protected BuilderBase() {
        }

        public BUILDER from(ActivationResult prototype) {
            this.startingActivationPhase(prototype.startingActivationPhase());
            this.targetActivationPhase(prototype.targetActivationPhase());
            this.finishingActivationPhase(prototype.finishingActivationPhase());
            this.error(prototype.error());
            this.success(prototype.success());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.startingActivationPhase(builder.startingActivationPhase());
            this.targetActivationPhase(builder.targetActivationPhase());
            builder.finishingActivationPhase().ifPresent(this::finishingActivationPhase);
            builder.error().ifPresent(this::error);
            this.success(builder.success());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER startingActivationPhase(ActivationPhase startingActivationPhase) {
            Objects.requireNonNull(startingActivationPhase);
            this.startingActivationPhase = startingActivationPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER targetActivationPhase(ActivationPhase targetActivationPhase) {
            Objects.requireNonNull(targetActivationPhase);
            this.targetActivationPhase = targetActivationPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER finishingActivationPhase(ActivationPhase finishingActivationPhase) {
            Objects.requireNonNull(finishingActivationPhase);
            this.finishingActivationPhase = finishingActivationPhase;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearError() {
            this.error = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER error(Throwable error) {
            Objects.requireNonNull(error);
            this.error = error;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER success(boolean success) {
            this.success = success;
            return (BUILDER)((BuilderBase)this.self());
        }

        public ActivationPhase startingActivationPhase() {
            return this.startingActivationPhase;
        }

        public ActivationPhase targetActivationPhase() {
            return this.targetActivationPhase;
        }

        public Optional<ActivationPhase> finishingActivationPhase() {
            return Optional.ofNullable(this.finishingActivationPhase);
        }

        public Optional<Throwable> error() {
            return Optional.ofNullable(this.error);
        }

        public boolean success() {
            return this.success;
        }

        public String toString() {
            return "ActivationResultBuilder{startingActivationPhase=" + String.valueOf((Object)this.startingActivationPhase) + ",targetActivationPhase=" + String.valueOf((Object)this.targetActivationPhase) + ",finishingActivationPhase=" + String.valueOf((Object)this.finishingActivationPhase) + ",error=" + String.valueOf(this.error) + ",success=" + this.success + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.finishingActivationPhase == null) {
                collector.fatal(this.getClass(), "Property \"finishingActivationPhase\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER error(Optional<? extends Throwable> error) {
            Objects.requireNonNull(error);
            this.error = error.map(Throwable.class::cast).orElse(this.error);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ActivationResultImpl
        implements ActivationResult {
            private final ActivationPhase finishingActivationPhase;
            private final ActivationPhase startingActivationPhase;
            private final ActivationPhase targetActivationPhase;
            private final boolean success;
            private final Optional<Throwable> error;

            protected ActivationResultImpl(BuilderBase<?, ?> builder) {
                this.startingActivationPhase = builder.startingActivationPhase();
                this.targetActivationPhase = builder.targetActivationPhase();
                this.finishingActivationPhase = builder.finishingActivationPhase().get();
                this.error = builder.error();
                this.success = builder.success();
            }

            @Override
            public ActivationPhase startingActivationPhase() {
                return this.startingActivationPhase;
            }

            @Override
            public ActivationPhase targetActivationPhase() {
                return this.targetActivationPhase;
            }

            @Override
            public ActivationPhase finishingActivationPhase() {
                return this.finishingActivationPhase;
            }

            @Override
            public Optional<Throwable> error() {
                return this.error;
            }

            @Override
            public boolean success() {
                return this.success;
            }

            public String toString() {
                return "ActivationResult{startingActivationPhase=" + String.valueOf((Object)this.startingActivationPhase) + ",targetActivationPhase=" + String.valueOf((Object)this.targetActivationPhase) + ",finishingActivationPhase=" + String.valueOf((Object)this.finishingActivationPhase) + ",error=" + String.valueOf(this.error) + ",success=" + this.success + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ActivationResult)) {
                    return false;
                }
                ActivationResult other = (ActivationResult)o;
                return Objects.equals((Object)this.startingActivationPhase, (Object)other.startingActivationPhase()) && Objects.equals((Object)this.targetActivationPhase, (Object)other.targetActivationPhase()) && Objects.equals((Object)this.finishingActivationPhase, (Object)other.finishingActivationPhase()) && Objects.equals(this.error, other.error()) && this.success == other.success();
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.startingActivationPhase, this.targetActivationPhase, this.finishingActivationPhase, this.error, this.success});
            }
        }
    }
}

