/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Provider;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

final class FieldTypes {
    private TypedField field0;
    private TypedField field1;
    private TypedField field2;

    FieldTypes() {
    }

    static FieldTypes create(Type type2) {
        FieldTypes ft = new FieldTypes();
        TypedField firstType = FieldTypes.getTypedField(type2);
        if (Provider.class.isAssignableFrom(firstType.rawType)) {
            firstType = ft.field0 = FieldTypes.getTypedField(firstType);
        } else {
            ft.field0 = firstType;
        }
        ft.field1 = FieldTypes.getTypedField(ft.field0);
        ft.field2 = firstType.rawType == Optional.class || firstType.rawType == Supplier.class ? FieldTypes.getTypedField(ft.field1) : ft.field1;
        return ft;
    }

    private static TypedField getTypedField(Type type2) {
        if (type2 instanceof Class) {
            return new TypedField((Class)type2);
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type2;
            return new TypedField((Class)paramType.getRawType(), paramType);
        }
        throw new UnsupportedOperationException("No idea how to handle " + String.valueOf(type2));
    }

    private static TypedField getTypedField(TypedField field) {
        if (field.isParameterized()) {
            ParameterizedType paramType = field.paramType;
            Object[] typeArgs = paramType.getActualTypeArguments();
            if (typeArgs.length == 1) {
                Type typeArg = typeArgs[0];
                return FieldTypes.getTypedField(typeArg);
            }
            if (typeArgs.length == 2 && field.rawType == Map.class && typeArgs[0] == typeArgs[1] && typeArgs[0] == String.class) {
                return new TypedField(String.class);
            }
            throw new DeploymentException("Cannot create config property for " + String.valueOf(field.rawType) + ", params: " + Arrays.toString(typeArgs));
        }
        return field;
    }

    TypedField field0() {
        return this.field0;
    }

    TypedField field1() {
        return this.field1;
    }

    TypedField field2() {
        return this.field2;
    }

    record TypedField(Class<?> rawType, ParameterizedType paramType) {
        private TypedField(Class<?> rawType) {
            this(rawType, null);
        }

        private boolean isParameterized() {
            return this.paramType != null;
        }
    }
}

