/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import io.helidon.config.ConfigException;
import io.helidon.microprofile.config.FieldTypes;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;

class FieldSetter {
    private final Field field;
    private final String configKey;
    private final Class<?> fieldType;
    private final String defaultValue;
    private final boolean isOptional;
    private final boolean isList;

    FieldSetter(Field field, String configKey, String defaultValue) {
        this.field = field;
        this.configKey = configKey;
        this.defaultValue = defaultValue;
        FieldTypes fieldTypes = FieldTypes.create(field.getGenericType());
        this.isOptional = fieldTypes.field0().rawType().equals(Optional.class);
        this.isList = fieldTypes.field0().rawType().equals(List.class);
        this.fieldType = this.isOptional || this.isList ? fieldTypes.field1().rawType() : field.getType();
        field.setAccessible(true);
    }

    void set(Config config, String prefix, Object instance) {
        String prefixedKey = this.prefixed(prefix, this.configKey);
        try {
            if (this.defaultValue != null) {
                this.setValue(prefixedKey, this.field, instance, this.valueWithDefault(config, prefixedKey));
            } else {
                Object currentValue = this.field.get(instance);
                if (this.isList) {
                    Optional<List<?>> value = config.getOptionalValues(prefixedKey, this.fieldType);
                    if (currentValue == null) {
                        if (value.isPresent()) {
                            this.setValue(prefixedKey, this.field, instance, value.get());
                        } else {
                            this.setValue(prefixedKey, this.field, instance, null);
                        }
                    } else if (value.isPresent()) {
                        this.setValue(prefixedKey, this.field, instance, value.get());
                    }
                } else {
                    Optional<?> value = config.getOptionalValue(prefixedKey, this.fieldType);
                    if (currentValue == null) {
                        if (value.isPresent()) {
                            this.setValue(prefixedKey, this.field, instance, value.get());
                        } else {
                            this.setValue(prefixedKey, this.field, instance, null);
                        }
                    } else if (value.isPresent()) {
                        this.setValue(prefixedKey, this.field, instance, value.get());
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new ConfigException("Failed to set config properties field value for " + String.valueOf(this.field), e);
        }
    }

    void setValue(String prefixedKey, Field field, Object instance, Object value) throws IllegalAccessException {
        if (value == null) {
            if (this.isOptional) {
                field.set(instance, Optional.empty());
                return;
            }
            throw new NoSuchElementException("Cannot set field " + String.valueOf(field) + ", as configuration key " + prefixedKey + " is missing.");
        }
        if (this.isOptional) {
            field.set(instance, Optional.of(value));
        } else {
            field.set(instance, value);
        }
    }

    private Object valueWithDefault(Config config, String prefixedKey) {
        Optional<?> maybeValue = config.getOptionalValue(prefixedKey, this.fieldType);
        return maybeValue.orElseGet(() -> this.defaultValue(config));
    }

    private Object defaultValue(Config config) {
        return config.getConverter(this.fieldType).map(it -> it.convert(this.defaultValue)).orElseThrow(() -> new IllegalArgumentException("Cannot find converter for type " + String.valueOf(this.fieldType) + " to convert default value of field " + String.valueOf(this.field)));
    }

    String prefixed(String prefix, String key) {
        if (prefix == null) {
            return key;
        }
        return prefix + "." + key;
    }

    void validate(Supplier<Object> instanceCreator, Config config, String prefix) {
        String prefixedKey = this.prefixed(prefix, this.configKey);
        Optional<String> value = config.getOptionalValue(prefixedKey, String.class).or(() -> Optional.ofNullable(this.defaultValue));
        if (value.isPresent()) {
            return;
        }
        if (this.isOptional) {
            return;
        }
        if (this.hasFieldValue(instanceCreator, this.field)) {
            return;
        }
        throw new DeploymentException("Cannot find configuration key " + prefixedKey + " for field " + String.valueOf(this.field));
    }

    private boolean hasFieldValue(Supplier<Object> instanceCreator, Field field) {
        Object instance = instanceCreator.get();
        try {
            Object value = field.get(instance);
            return value != null;
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to get field value for field " + String.valueOf(field), e);
        }
    }
}

