/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.logging.common;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.NativeImageHelper;
import io.helidon.logging.common.spi.LoggingProvider;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LogConfig {
    private static final AtomicBoolean RUNTIME_CONFIGURED = new AtomicBoolean();
    private static final LoggingProvider PROVIDER;

    private LogConfig() {
    }

    public static void configureRuntime() {
        if (NativeImageHelper.isRuntime() && RUNTIME_CONFIGURED.compareAndSet(false, true)) {
            PROVIDER.runTime();
        }
    }

    public static void initClass() {
    }

    static {
        List<LoggingProvider> providers = HelidonServiceLoader.create(ServiceLoader.load(LoggingProvider.class)).asList();
        if (providers.isEmpty()) {
            System.err.println("There is no Helidon logging implementation on classpath, skipping log configuration.");
            PROVIDER = new NoOpProvider();
        } else {
            PROVIDER = providers.get(0);
        }
        PROVIDER.initialization();
        if (providers.size() > 1) {
            System.getLogger(LogConfig.class.getName()).log(System.Logger.Level.TRACE, "Multiple logging providers on classpath, using the first one: " + PROVIDER.getClass().getName());
        }
    }

    private static final class NoOpProvider
    implements LoggingProvider {
        private NoOpProvider() {
        }

        @Override
        public void initialization() {
        }

        @Override
        public void runTime() {
        }
    }
}

