/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.yaml.mp;

import io.helidon.config.ConfigException;
import io.helidon.config.mp.spi.MpConfigSourceProvider;
import io.helidon.config.yaml.mp.YamlMpConfigSource;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class YamlConfigSourceProvider
implements MpConfigSourceProvider {
    private static final String RESOURCE_NAME = "application.yaml";

    @Override
    public Iterable<ConfigSource> getConfigSources(ClassLoader classLoader) {
        return this.configSources(classLoader, null);
    }

    @Override
    public Iterable<ConfigSource> getConfigSources(ClassLoader classLoader, String profile) {
        Objects.requireNonNull(profile, "Profile must not be null");
        return this.configSources(classLoader, profile);
    }

    private Iterable<ConfigSource> configSources(ClassLoader classLoader, String profile) {
        LinkedList<ConfigSource> result = new LinkedList<ConfigSource>();
        if (profile == null) {
            Enumeration<URL> resources;
            try {
                resources = classLoader.getResources(RESOURCE_NAME);
            }
            catch (IOException e) {
                throw new ConfigException("Failed to read resources from classpath", e);
            }
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                result.add(YamlMpConfigSource.create(url));
            }
        } else {
            result.addAll(YamlMpConfigSource.classPath(RESOURCE_NAME, profile, classLoader));
        }
        return result;
    }
}

