/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.yaml;

import io.helidon.common.Weight;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.ConfigException;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigParserException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

@Weight(value=90.0)
public class YamlConfigParser
implements ConfigParser {
    public static final double WEIGHT = 90.0;
    private static final Set<MediaType> SUPPORTED_MEDIA_TYPES = Set.of(MediaTypes.APPLICATION_YAML, MediaTypes.APPLICATION_X_YAML);
    private static final List<String> SUPPORTED_SUFFIXES = List.of("yml", "yaml");

    @Deprecated
    public YamlConfigParser() {
        if (System.getProperty("java.runtime.name") == null) {
            System.setProperty("java.runtime.name", "unknown");
        }
    }

    public static YamlConfigParser create() {
        return new YamlConfigParser();
    }

    @Override
    public Set<MediaType> supportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    @Override
    public List<String> supportedSuffixes() {
        return SUPPORTED_SUFFIXES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigNode.ObjectNode parse(ConfigParser.Content content) throws ConfigParserException {
        try (InputStreamReader reader = new InputStreamReader(content.data(), content.charset());){
            Map yamlMap = YamlConfigParser.toMap(reader);
            if (yamlMap == null) {
                ConfigNode.ObjectNode objectNode = ConfigNode.ObjectNode.empty();
                return objectNode;
            }
            ConfigNode.ObjectNode objectNode = YamlConfigParser.fromMap(yamlMap);
            return objectNode;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigParserException("Cannot read from source: " + e.getLocalizedMessage(), e);
        }
    }

    static Map toMap(Reader reader) {
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        return (Map)yaml.loadAs(reader, Object.class);
    }

    private static ConfigNode.ObjectNode fromMap(Map<?, ?> map) {
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        if (map != null) {
            map.forEach((k, v) -> {
                String strKey = k.toString();
                if (v instanceof List) {
                    List listValue = (List)v;
                    builder.addList(strKey, YamlConfigParser.fromList(listValue));
                } else if (v instanceof Map) {
                    Map mapValue = (Map)v;
                    builder.addObject(strKey, YamlConfigParser.fromMap(mapValue));
                } else {
                    String strValue = v == null ? "" : v.toString();
                    builder.addValue(strKey, strValue);
                }
            });
        }
        return builder.build();
    }

    private static ConfigNode.ListNode fromList(List<?> list) {
        ConfigNode.ListNode.Builder builder = ConfigNode.ListNode.builder();
        list.forEach(value -> {
            if (value instanceof List) {
                List listValue = (List)value;
                builder.addList(YamlConfigParser.fromList(listValue));
            } else if (value instanceof Map) {
                Map mapValue = (Map)value;
                builder.addObject(YamlConfigParser.fromMap(mapValue));
            } else {
                String strValue = value == null ? "" : value.toString();
                builder.addValue(strValue);
            }
        });
        return (ConfigNode.ListNode)builder.build();
    }
}

