/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.config.spi.ChangeEventType;
import java.time.Instant;
import java.util.function.Consumer;

public interface ChangeWatcher<T> {
    public void start(T var1, Consumer<ChangeEvent<T>> var2);

    default public void stop() {
    }

    public Class<T> type();

    public static interface ChangeEvent<T> {
        public Instant changeTime();

        public T target();

        public ChangeEventType type();

        public static <T> ChangeEvent<T> create(final T target, final ChangeEventType type2, final Instant instant) {
            return new ChangeEvent<T>(){

                @Override
                public Instant changeTime() {
                    return instant;
                }

                @Override
                public T target() {
                    return target;
                }

                @Override
                public ChangeEventType type() {
                    return type2;
                }

                public String toString() {
                    return String.valueOf((Object)type2) + " " + String.valueOf(target);
                }
            };
        }

        public static <T> ChangeEvent<T> create(T target, ChangeEventType type2) {
            return ChangeEvent.create(target, type2, Instant.now());
        }
    }
}

