/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.Config;
import io.helidon.config.mp.MpConfigSources;
import io.helidon.config.mp.MpMetaConfigUtils;
import io.helidon.config.mp.Prioritized;
import io.helidon.config.mp.spi.MpMetaConfigProvider;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

class MpPropertiesMetaConfigProvider
implements MpMetaConfigProvider,
Prioritized {
    MpPropertiesMetaConfigProvider() {
    }

    @Override
    public Set<String> supportedTypes() {
        return Set.of("properties");
    }

    @Override
    public List<? extends ConfigSource> create(String type2, Config metaConfig, String profile) {
        return MpMetaConfigUtils.sourceFromMeta(metaConfig, profile, MpConfigSources::create, MpConfigSources::classPath, MpConfigSources::classPath, MpConfigSources::create);
    }

    @Override
    public int priority() {
        return 300;
    }

    @Override
    public ConfigSource create(Reader content) {
        Properties p = new Properties();
        try {
            p.load(content);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return MpConfigSources.create("MpPropertiesMetaConfigProvider", p);
    }
}

