/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.Builder;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

final class MpMetaConfig {
    private static final String META_CONFIG_ENV_VAR = "HELIDON_MP_META_CONFIG";
    static final String META_CONFIG_SYSTEM_PROPERTY = "io.helidon.config.mp.meta-config";
    private static final System.Logger LOGGER = System.getLogger(MpMetaConfig.class.getName());

    private MpMetaConfig() {
    }

    static Optional<Config> metaConfig() {
        return MpMetaConfig.findMetaConfig().map(it -> Config.builder().disableValueResolving().disableKeyResolving().disableFilterServices().disableEnvironmentVariablesSource().disableSystemPropertiesSource().disableMapperServices().addSource((io.helidon.config.spi.ConfigSource)it).build());
    }

    private static Optional<io.helidon.config.spi.ConfigSource> findMetaConfig() {
        String fileName = System.getenv(META_CONFIG_ENV_VAR);
        if (fileName == null) {
            fileName = System.getProperty(META_CONFIG_SYSTEM_PROPERTY);
        }
        Optional<Object> found = fileName == null ? Optional.empty() : MpMetaConfig.findMetaConfig(fileName);
        return found.or(() -> MpMetaConfig.findMetaConfig("mp-meta-config.yaml")).or(() -> MpMetaConfig.findMetaConfig("mp-meta-config.properties"));
    }

    private static Optional<io.helidon.config.spi.ConfigSource> findMetaConfig(String fileName) {
        return MpMetaConfig.findFile(fileName).or(() -> MpMetaConfig.findClasspath(MpMetaConfig.class.getClassLoader(), fileName));
    }

    private static Optional<io.helidon.config.spi.ConfigSource> findFile(String name) {
        Path path = Paths.get(name, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isReadable(path) && !Files.isDirectory(path, new LinkOption[0])) {
            LOGGER.log(System.Logger.Level.INFO, "Found MP meta configuration file: " + String.valueOf(path.toAbsolutePath()));
            return Optional.of(ConfigSources.file(path).build());
        }
        return Optional.empty();
    }

    private static Optional<io.helidon.config.spi.ConfigSource> findClasspath(ClassLoader cl, String name) {
        URL resource = cl.getResource(name);
        if (null != resource) {
            LOGGER.log(System.Logger.Level.DEBUG, () -> "Found MP meta configuration resource: " + resource.getPath());
            return Optional.of(ConfigSources.classpath(name).build());
        }
        return Optional.empty();
    }

    static class MetaConfigSource
    implements ConfigSource {
        private final ConfigSource delegate;
        private final int ordinal;
        private final String name;

        MetaConfigSource(Builder builder) {
            this.delegate = builder.delegate;
            this.ordinal = builder.ordinal;
            this.name = builder.sourceName;
        }

        static Builder builder() {
            return new Builder();
        }

        @Override
        public Map<String, String> getProperties() {
            return this.delegate.getProperties();
        }

        @Override
        public String getValue(String propertyName) {
            return this.delegate.getValue(propertyName);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getPropertyNames() {
            return this.delegate.getPropertyNames();
        }

        @Override
        public int getOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            return this.name + "(" + this.ordinal + "), wrapping: " + this.delegate.toString();
        }

        static class Builder
        implements io.helidon.common.Builder<Builder, MetaConfigSource> {
            private ConfigSource delegate;
            private int ordinal;
            private boolean ordinalNotSet = true;
            private String sourceName;
            private boolean nameNotSet = true;

            private Builder() {
            }

            @Override
            public MetaConfigSource build() {
                return new MetaConfigSource(this);
            }

            Builder delegate(ConfigSource delegate) {
                this.delegate = delegate;
                if (this.ordinalNotSet) {
                    this.ordinal = delegate.getOrdinal();
                }
                if (this.nameNotSet) {
                    this.sourceName = delegate.getName();
                }
                return this;
            }

            Builder ordinal(int ordinal) {
                this.ordinal = ordinal;
                this.ordinalNotSet = false;
                return this;
            }

            Builder name(String sourceName) {
                this.sourceName = sourceName;
                this.nameNotSet = false;
                return this;
            }
        }
    }
}

