/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.Builder;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.ConfigValue;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappers;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.config.mp.MpConfigImpl;
import io.helidon.config.mp.MpConfigSources;
import io.helidon.config.mp.MpConverters;
import io.helidon.config.mp.MpMetaConfig;
import io.helidon.config.mp.Priorities;
import io.helidon.config.mp.spi.MpConfigFilter;
import io.helidon.config.mp.spi.MpConfigSourceProvider;
import io.helidon.config.mp.spi.MpMetaConfigProvider;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.ServiceLoader;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

@Configured(prefix="mp.config", root=true)
class MpConfigBuilder
implements Builder<MpConfigBuilder, org.eclipse.microprofile.config.Config>,
ConfigBuilder {
    private static final System.Logger LOGGER = System.getLogger(MpConfigBuilder.class.getName());
    private static final String DEFAULT_CONFIG_SOURCE = "META-INF/microprofile-config.properties";
    private final List<OrdinalSource> sources = new LinkedList<OrdinalSource>();
    private final List<OrdinalConverter> converters = new LinkedList<OrdinalConverter>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private boolean useDefaultSources = false;
    private boolean useDiscoveredSources = false;
    private boolean useDiscoveredConverters = false;
    private String profile;

    MpConfigBuilder() {
    }

    private static File toFile(String value) {
        return new File(value);
    }

    private static Path toPath(String value) {
        return Paths.get(value, new String[0]);
    }

    private static Class<?> toClass(String stringValue) {
        try {
            return Class.forName(stringValue);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to convert property " + stringValue + " to class", e);
        }
    }

    private static char toChar(String stringValue) {
        if (stringValue.length() != 1) {
            throw new IllegalArgumentException("The string to map must be a single character, but is: " + stringValue);
        }
        return stringValue.charAt(0);
    }

    private static Class<?> getConverterType(Class<?> converterClass) {
        Class<?> type2 = MpConfigBuilder.doGetType(converterClass);
        if (null == type2) {
            throw new IllegalArgumentException("Converter " + String.valueOf(converterClass) + " must be a ParameterizedType.");
        }
        return type2;
    }

    private static Class<?> doGetType(Class<?> clazz) {
        Type[] genericInterfaces;
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(genericInterface instanceof ParameterizedType) || !(pt = (ParameterizedType)genericInterface).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + String.valueOf(clazz) + " must be a ParameterizedType.");
            }
            Type typeArgument = typeArguments[0];
            if (typeArgument instanceof Class) {
                return (Class)typeArgument;
            }
            throw new IllegalStateException("Converter " + String.valueOf(clazz) + " must convert to a class, not " + String.valueOf(typeArgument));
        }
        return MpConfigBuilder.doGetType(clazz.getSuperclass());
    }

    @Override
    public ConfigBuilder addDefaultSources() {
        this.useDefaultSources = true;
        return this;
    }

    @Override
    public ConfigBuilder addDiscoveredSources() {
        this.useDiscoveredSources = true;
        return this;
    }

    @Override
    public ConfigBuilder addDiscoveredConverters() {
        this.useDiscoveredConverters = true;
        return this;
    }

    @Override
    public ConfigBuilder forClassLoader(ClassLoader loader) {
        this.classLoader = loader;
        return this;
    }

    @Override
    public ConfigBuilder withSources(ConfigSource ... sources) {
        for (ConfigSource source : sources) {
            this.sources.add(new OrdinalSource(source));
        }
        return this;
    }

    @Override
    public <T> ConfigBuilder withConverter(Class<T> aClass, int ordinal, Converter<T> converter) {
        this.converters.add(new OrdinalConverter(converter, aClass, ordinal));
        return this;
    }

    @Override
    public ConfigBuilder withConverters(Converter<?> ... converters) {
        for (Converter<?> converter : converters) {
            this.converters.add(new OrdinalConverter(converter));
        }
        return this;
    }

    void mpMetaConfig(Config meta) {
        meta.get("profile").asString().ifPresent(this::profile);
        meta.get("add-discovered-sources").asBoolean().filter(it -> it).ifPresent(it -> this.addDiscoveredSources());
        meta.get("add-discovered-converters").asBoolean().filter(it -> it).ifPresent(it -> this.addDiscoveredConverters());
        meta.get("add-default-sources").asBoolean().filter(it -> it).ifPresent(it -> this.addDefaultSources());
        meta.get("sources").asNodeList().ifPresent(this::processMetaSources);
    }

    private void processMetaSources(List<Config> configs) {
        for (Config config : configs) {
            String type2 = (String)config.get("type").asString().orElseThrow(() -> new ConfigException("Meta configuration sources must have a \"type\" property defined"));
            MpMetaConfigProvider mpMetaConfigProvider = MpConfigSources.MP_META_PROVIDERS.get(type2);
            if (mpMetaConfigProvider == null) {
                throw new ConfigException("Wrong meta configuration, type " + type2 + " not supported, only supporting: " + String.valueOf(MpConfigSources.MP_META_PROVIDERS.keySet()));
            }
            List<? extends ConfigSource> delegates = mpMetaConfigProvider.create(type2, config, this.profile);
            boolean shouldCount = delegates.size() > 1;
            int counter = 0;
            for (ConfigSource configSource : delegates) {
                MpMetaConfig.MetaConfigSource.Builder builder = MpMetaConfig.MetaConfigSource.builder().delegate(configSource);
                config.get("ordinal").asInt().ifPresent(builder::ordinal);
                ConfigValue name = config.get("name").asString();
                if (shouldCount) {
                    if (name.isPresent()) {
                        builder.name((String)name.get() + "_" + counter++);
                    }
                } else {
                    name.ifPresent(builder::name);
                }
                this.withSources(builder.build());
            }
        }
    }

    @Override
    public org.eclipse.microprofile.config.Config build() {
        LinkedList<OrdinalSource> ordinalSources = new LinkedList<OrdinalSource>(this.sources);
        LinkedList<OrdinalConverter> ordinalConverters = new LinkedList<OrdinalConverter>(this.converters);
        List<MpConfigFilter> targetFilters = HelidonServiceLoader.create(ServiceLoader.load(MpConfigFilter.class)).asList();
        this.addBuiltInConverters(ordinalConverters);
        if (this.useDiscoveredConverters) {
            this.addDiscoveredConverters(ordinalConverters);
        }
        if (this.useDefaultSources) {
            this.addDefaultSources(ordinalSources);
        }
        if (this.useDiscoveredSources) {
            this.addDiscoveredSources(ordinalSources);
        }
        ordinalSources.sort(Comparator.comparingInt(o -> o.ordinal));
        ordinalConverters.sort(Comparator.comparingInt(o -> o.ordinal));
        Collections.reverse(ordinalSources);
        Collections.reverse(ordinalConverters);
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "The following config sources are used (ordered): " + String.valueOf(ordinalSources));
        }
        LinkedList<ConfigSource> targetSources = new LinkedList<ConfigSource>();
        HashMap targetConverters = new HashMap();
        ordinalSources.forEach(ordinal -> targetSources.add(ordinal.source));
        ordinalConverters.forEach(ordinal -> targetConverters.putIfAbsent(ordinal.type, ordinal.converter));
        MpConfigImpl result = new MpConfigImpl(targetSources, targetConverters, targetFilters, this.profile);
        if (this.profile != null) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Built MP config for profile " + this.profile);
            }
            return result;
        }
        String configuredProfile = result.getOptionalValue("mp.config.profile", String.class).orElse(null);
        if (configuredProfile == null) {
            LOGGER.log(System.Logger.Level.DEBUG, "Built MP config with no profile");
            return result;
        }
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            LOGGER.log(System.Logger.Level.TRACE, "MP profile configured, rebuilding: " + configuredProfile);
        }
        this.profile(configuredProfile);
        return this.build();
    }

    @ConfiguredOption(key="profile", type=String.class, description="Configure an explicit profile name.")
    public MpConfigBuilder profile(String profile) {
        this.profile = profile;
        return this;
    }

    private void addDiscoveredSources(List<OrdinalSource> targetConfigSources) {
        ServiceLoader.load(ConfigSource.class).forEach(it -> targetConfigSources.add(new OrdinalSource((ConfigSource)it)));
        ServiceLoader.load(ConfigSourceProvider.class).forEach(it -> it.getConfigSources(this.classLoader).forEach(source -> targetConfigSources.add(new OrdinalSource((ConfigSource)source))));
        ServiceLoader.load(MpConfigSourceProvider.class).forEach(it -> (this.profile == null ? it.getConfigSources(this.classLoader) : it.getConfigSources(this.classLoader, this.profile)).forEach(source -> targetConfigSources.add(new OrdinalSource((ConfigSource)source))));
    }

    private void addDiscoveredConverters(List<OrdinalConverter> targetConverters) {
        ServiceLoader.load(Converter.class).forEach(it -> targetConverters.add(new OrdinalConverter((Converter<?>)it)));
    }

    private void addDefaultSources(List<OrdinalSource> targetConfigSources) {
        if (this.useDefaultSources) {
            targetConfigSources.add(new OrdinalSource(MpConfigSources.systemProperties(), 400));
            targetConfigSources.add(new OrdinalSource(MpConfigSources.environmentVariables(), 300));
            if (this.profile == null) {
                MpConfigSources.classPath(this.classLoader, DEFAULT_CONFIG_SOURCE).stream().map(OrdinalSource::new).forEach(targetConfigSources::add);
            } else {
                MpConfigSources.classPath(this.classLoader, DEFAULT_CONFIG_SOURCE, this.profile).stream().map(OrdinalSource::new).forEach(targetConfigSources::add);
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "The following default config sources discovered: " + String.valueOf(targetConfigSources));
            }
        }
    }

    private void addBuiltInConverters(List<OrdinalConverter> converters) {
        this.addBuiltIn(converters, Boolean.class, ConfigMappers::toBoolean);
        this.addBuiltIn(converters, Byte.class, Byte::parseByte);
        this.addBuiltIn(converters, Short.class, Short::parseShort);
        this.addBuiltIn(converters, Integer.class, Integer::parseInt);
        this.addBuiltIn(converters, OptionalInt.class, MpConverters::toOptionalInt);
        this.addBuiltIn(converters, Long.class, Long::parseLong);
        this.addBuiltIn(converters, OptionalLong.class, MpConverters::toOptionalLong);
        this.addBuiltIn(converters, Float.class, Float::parseFloat);
        this.addBuiltIn(converters, Double.class, Double::parseDouble);
        this.addBuiltIn(converters, OptionalDouble.class, MpConverters::toOptionalDouble);
        this.addBuiltIn(converters, Character.class, MpConfigBuilder::toChar);
        this.addBuiltIn(converters, Class.class, MpConfigBuilder::toClass);
        this.addBuiltIn(converters, BigDecimal.class, ConfigMappers::toBigDecimal);
        this.addBuiltIn(converters, BigInteger.class, ConfigMappers::toBigInteger);
        this.addBuiltIn(converters, Duration.class, ConfigMappers::toDuration);
        this.addBuiltIn(converters, Period.class, ConfigMappers::toPeriod);
        this.addBuiltIn(converters, LocalDate.class, ConfigMappers::toLocalDate);
        this.addBuiltIn(converters, LocalDateTime.class, ConfigMappers::toLocalDateTime);
        this.addBuiltIn(converters, LocalTime.class, ConfigMappers::toLocalTime);
        this.addBuiltIn(converters, ZonedDateTime.class, ConfigMappers::toZonedDateTime);
        this.addBuiltIn(converters, ZoneId.class, ConfigMappers::toZoneId);
        this.addBuiltIn(converters, ZoneOffset.class, ConfigMappers::toZoneOffset);
        this.addBuiltIn(converters, Instant.class, ConfigMappers::toInstant);
        this.addBuiltIn(converters, OffsetTime.class, ConfigMappers::toOffsetTime);
        this.addBuiltIn(converters, OffsetDateTime.class, ConfigMappers::toOffsetDateTime);
        this.addBuiltIn(converters, YearMonth.class, YearMonth::parse);
        this.addBuiltIn(converters, File.class, MpConfigBuilder::toFile);
        this.addBuiltIn(converters, Path.class, MpConfigBuilder::toPath);
        this.addBuiltIn(converters, Charset.class, ConfigMappers::toCharset);
        this.addBuiltIn(converters, URI.class, ConfigMappers::toUri);
        this.addBuiltIn(converters, URL.class, ConfigMappers::toUrl);
        this.addBuiltIn(converters, Pattern.class, ConfigMappers::toPattern);
        this.addBuiltIn(converters, UUID.class, ConfigMappers::toUUID);
        this.addBuiltIn(converters, Date.class, ConfigMappers::toDate);
        this.addBuiltIn(converters, Calendar.class, ConfigMappers::toCalendar);
        this.addBuiltIn(converters, GregorianCalendar.class, ConfigMappers::toGregorianCalendar);
        this.addBuiltIn(converters, TimeZone.class, ConfigMappers::toTimeZone);
        this.addBuiltIn(converters, SimpleTimeZone.class, ConfigMappers::toSimpleTimeZone);
    }

    private <T> void addBuiltIn(List<OrdinalConverter> converters, Class<T> clazz, Converter<T> converter) {
        converters.add(new OrdinalConverter(converter, clazz, 1));
    }

    ConfigBuilder metaConfig(Config metaConfig) {
        Config helidonConfig = Config.builder().config(metaConfig).build();
        this.sources.add(new OrdinalSource(MpConfigSources.create(helidonConfig)));
        return this;
    }

    private static class OrdinalSource {
        private final int ordinal;
        private final ConfigSource source;

        private OrdinalSource(ConfigSource source) {
            this.source = source;
            this.ordinal = OrdinalSource.findOrdinal(source, 100);
        }

        private OrdinalSource(ConfigSource source, int ordinal) {
            this.ordinal = OrdinalSource.findOrdinal(source, ordinal);
            this.source = source;
        }

        private static int findOrdinal(ConfigSource source, int defaultOrdinal) {
            int ordinal = source.getOrdinal();
            if (ordinal == 100) {
                return Priorities.find(source, defaultOrdinal);
            }
            return ordinal;
        }

        public String toString() {
            return this.ordinal + " " + this.source.getName();
        }
    }

    private static class OrdinalConverter {
        private final int ordinal;
        private final Class<?> type;
        private final Converter<?> converter;

        private OrdinalConverter(Converter<?> converter, Class<?> aClass, int ordinal) {
            this.ordinal = ordinal;
            this.type = aClass;
            this.converter = new NullCheckingConverter(aClass, converter);
        }

        private OrdinalConverter(Converter<?> converter) {
            this(converter, MpConfigBuilder.getConverterType(converter.getClass()), Priorities.find(converter, 100));
        }

        public String toString() {
            return this.type.getName() + "->" + String.valueOf(this.converter);
        }
    }

    private static final class NullCheckingConverter<T>
    implements Converter<T> {
        private final Converter<T> delegate;
        private final Class<?> type;

        private NullCheckingConverter(Class<?> type2, Converter<T> delegate) {
            this.delegate = delegate;
            this.type = type2;
        }

        @Override
        public T convert(String value) throws IllegalArgumentException, NullPointerException {
            if (value == null) {
                throw new NullPointerException("Null not allowed in MP converters. Converter for type " + this.type.getName());
            }
            try {
                return this.delegate.convert(value);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot convert value", e);
            }
        }

        public String toString() {
            return this.type.getName() + "->" + String.valueOf(this.delegate);
        }
    }
}

