/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractSource;
import io.helidon.config.AbstractSourceBuilder;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigUtils;
import io.helidon.config.UrlHelper;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.WatchableSource;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public class UrlOverrideSource
extends AbstractSource
implements OverrideSource,
PollableSource<Instant>,
WatchableSource<URL> {
    private static final System.Logger LOGGER = System.getLogger(UrlOverrideSource.class.getName());
    private static final String GET_METHOD = "GET";
    private static final String URL_KEY = "url";
    private final URL url;

    UrlOverrideSource(Builder builder) {
        super(builder);
        this.url = builder.url;
    }

    public static UrlOverrideSource create(Config metaConfig) {
        return UrlOverrideSource.builder().config(metaConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isModified(Instant stamp) {
        return UrlHelper.isModified(this.url, stamp);
    }

    @Override
    public Optional<PollingStrategy> pollingStrategy() {
        return super.pollingStrategy();
    }

    @Override
    public URL target() {
        return this.url;
    }

    @Override
    public Class<URL> targetType() {
        return URL.class;
    }

    @Override
    public Optional<ChangeWatcher<Object>> changeWatcher() {
        return super.changeWatcher();
    }

    @Override
    public Optional<ConfigContent.OverrideContent> load() throws ConfigException {
        try {
            Instant timestamp;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod(GET_METHOD);
            if (404 == connection.getResponseCode()) {
                return Optional.empty();
            }
            if (connection.getLastModified() == 0L) {
                timestamp = Instant.now();
                LOGGER.log(System.Logger.Level.DEBUG, "Missing GET '" + String.valueOf(this.url) + "' response header 'Last-Modified'. Used current time '" + String.valueOf(timestamp) + "' as a content timestamp.");
            } else {
                timestamp = Instant.ofEpochMilli(connection.getLastModified());
            }
            InputStreamReader reader = new InputStreamReader(connection.getInputStream(), ConfigUtils.getContentCharset(connection.getContentEncoding()));
            ConfigContent.OverrideContent.Builder builder = (ConfigContent.OverrideContent.Builder)ConfigContent.OverrideContent.builder().data(OverrideSource.OverrideData.create(reader)).stamp(timestamp);
            return Optional.of(builder.build());
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Configuration at url '" + String.valueOf(this.url) + "' GET is not accessible.", ex);
        }
    }

    @Override
    protected String uid() {
        return this.url.toString();
    }

    public static final class Builder
    extends AbstractSourceBuilder<Builder, URL>
    implements PollableSource.Builder<Builder>,
    WatchableSource.Builder<Builder, URL>,
    io.helidon.common.Builder<Builder, UrlOverrideSource> {
        private URL url;

        private Builder() {
        }

        @Override
        public UrlOverrideSource build() {
            Objects.requireNonNull(this.url, "url cannot be null");
            return new UrlOverrideSource(this);
        }

        @Override
        public Builder config(Config metaConfig) {
            metaConfig.get(UrlOverrideSource.URL_KEY).as(URL.class).ifPresent(this::url);
            return (Builder)super.config(metaConfig);
        }

        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        @Override
        public Builder changeWatcher(ChangeWatcher<URL> changeWatcher) {
            return (Builder)super.changeWatcher(changeWatcher);
        }

        @Override
        public Builder pollingStrategy(PollingStrategy pollingStrategy) {
            return (Builder)super.pollingStrategy(pollingStrategy);
        }
    }
}

