/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.Weight;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.ConfigUtils;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigParserException;
import java.util.Properties;
import java.util.Set;

@Weight(value=90.0)
public class PropertiesConfigParser
implements ConfigParser {
    public static final MediaType MEDIA_TYPE_TEXT_JAVA_PROPERTIES = MediaTypes.create("text/x-java-properties");
    public static final double WEIGHT = 90.0;
    private static final Set<MediaType> SUPPORTED_MEDIA_TYPES = Set.of(MEDIA_TYPE_TEXT_JAVA_PROPERTIES);

    @Override
    public Set<MediaType> supportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    @Override
    public ConfigNode.ObjectNode parse(ConfigParser.Content content) throws ConfigParserException {
        Properties properties = new Properties();
        try {
            properties.load(content.data());
        }
        catch (Exception e) {
            throw new ConfigParserException("Cannot read from source: " + e.getLocalizedMessage(), e);
        }
        return ConfigUtils.mapToObjectNode(ConfigUtils.propertiesToMap(properties), true);
    }
}

