/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.Builder;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.ScheduledPollingStrategy;
import io.helidon.config.spi.PollingStrategy;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;

public final class PollingStrategies {
    private PollingStrategies() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    public static PollingStrategy nop() {
        return NopPollingStrategyHolder.NOP;
    }

    public static ScheduledBuilder regular(Duration interval) {
        return new ScheduledBuilder(new ScheduledPollingStrategy.RegularRecurringPolicy(interval));
    }

    private static final class NopPollingStrategyHolder {
        private static final PollingStrategy NOP = polled -> {};

        private NopPollingStrategyHolder() {
            throw new AssertionError((Object)"Instantiation not allowed.");
        }
    }

    public static final class ScheduledBuilder
    implements Builder<ScheduledBuilder, PollingStrategy> {
        private static final String INTERVAL_KEY = "interval";
        private ScheduledPollingStrategy.RecurringPolicy recurringPolicy;
        private ScheduledExecutorService executor;

        ScheduledBuilder(ScheduledPollingStrategy.RecurringPolicy recurringPolicy) {
            this.recurringPolicy = recurringPolicy;
        }

        public static ScheduledBuilder create(Config metaConfig) throws ConfigMappingException, MissingValueException {
            return PollingStrategies.regular((Duration)metaConfig.get(INTERVAL_KEY).as(Duration.class).get());
        }

        public ScheduledBuilder executor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public PollingStrategy build() {
            ScheduledExecutorService executor = this.executor;
            return ScheduledPollingStrategy.create(this.recurringPolicy, executor);
        }

        @Override
        public PollingStrategy get() {
            return this.build();
        }
    }
}

