/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractNodeBuilderImpl;
import io.helidon.config.ConfigException;
import io.helidon.config.ListNodeImpl;
import io.helidon.config.MergeableNode;
import io.helidon.config.spi.ConfigNode;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class ListNodeBuilderImpl
extends AbstractNodeBuilderImpl<Integer, ConfigNode.ListNode.Builder>
implements ConfigNode.ListNode.Builder {
    private final List<MergeableNode> elements = new LinkedList<MergeableNode>();
    private String value;

    public ListNodeBuilderImpl() {
        this(Function.identity());
    }

    public ListNodeBuilderImpl(Function<String, String> resolveTokenFunctions) {
        super(resolveTokenFunctions);
    }

    static ListNodeBuilderImpl from(List<ConfigNode> elements) {
        return ListNodeBuilderImpl.from(elements, Function.identity());
    }

    static ListNodeBuilderImpl from(List<ConfigNode> elements, Function<String, String> resolveTokenFunction) {
        ListNodeBuilderImpl builder = new ListNodeBuilderImpl(resolveTokenFunction);
        elements.forEach(builder::addNode);
        return builder;
    }

    public ListNodeBuilderImpl addNode(ConfigNode node) {
        this.elements.add(ListNodeBuilderImpl.wrap(node));
        return this;
    }

    @Override
    public ListNodeBuilderImpl value(String value) {
        this.value = value;
        return this;
    }

    ListNodeBuilderImpl value(Optional<String> value) {
        value.ifPresent(this::value);
        return this;
    }

    @Override
    protected Integer id(AbstractNodeBuilderImpl.MergingKey key) {
        String name = key.first();
        try {
            int index = Integer.parseInt(name);
            if (index < 0) {
                throw new ConfigException("Cannot merge an OBJECT member '" + name + "' into a LIST element. Illegal negative index " + index + ".");
            }
            if (index >= this.elements.size()) {
                throw new ConfigException("Cannot merge an OBJECT member '" + name + "' into a LIST element. Index " + index + " out of bounds <0, " + (this.elements.size() - 1) + ">.");
            }
            return index;
        }
        catch (NumberFormatException ex) {
            throw new ConfigException("Cannot merge an OBJECT member '" + name + "' into a LIST element, not a number.", ex);
        }
    }

    @Override
    protected MergeableNode member(Integer index) {
        return this.elements.get(index);
    }

    @Override
    protected void update(Integer index, MergeableNode node) {
        this.elements.set(index, ListNodeBuilderImpl.wrap(node));
    }

    @Override
    protected void merge(Integer index, MergeableNode node) {
        try {
            this.elements.set(index, this.elements.get(index).merge(node));
        }
        catch (ConfigException ex) {
            throw new ConfigException(index + ": " + ex.getLocalizedMessage(), ex);
        }
    }

    @Override
    public ConfigNode.ListNode.Builder addValue(ConfigNode.ValueNode value) {
        return this.addNode(value);
    }

    @Override
    public ConfigNode.ListNode.Builder addObject(ConfigNode.ObjectNode object) {
        return this.addNode(object);
    }

    @Override
    public ConfigNode.ListNode.Builder addList(ConfigNode.ListNode list) {
        return this.addNode(list);
    }

    @Override
    public ListNodeImpl build() {
        return new ListNodeImpl(this.elements, this.value);
    }

    public String toString() {
        return "ListNodeBuilderImpl{elements=" + String.valueOf(this.elements) + "} " + super.toString();
    }
}

