/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractConfigSource;
import io.helidon.config.AbstractConfigSourceBuilder;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.FileSourceHelper;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.NodeConfigSource;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.WatchableSource;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;

public class DirectoryConfigSource
extends AbstractConfigSource
implements PollableSource<Instant>,
WatchableSource<Path>,
NodeConfigSource {
    private static final String PATH_KEY = "path";
    private final Path directoryPath;

    DirectoryConfigSource(Builder builder) {
        super(builder);
        this.directoryPath = builder.path;
    }

    public static DirectoryConfigSource create(Config metaConfig) throws ConfigMappingException, MissingValueException {
        return DirectoryConfigSource.builder().config(metaConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected String uid() {
        return this.directoryPath.toString();
    }

    @Override
    public boolean isModified(Instant stamp) {
        return FileSourceHelper.isModified(this.directoryPath, stamp);
    }

    @Override
    public Optional<PollingStrategy> pollingStrategy() {
        return super.pollingStrategy();
    }

    @Override
    public Optional<ChangeWatcher<Object>> changeWatcher() {
        return super.changeWatcher();
    }

    @Override
    public Path target() {
        return this.directoryPath;
    }

    @Override
    public boolean exists() {
        return Files.exists(this.directoryPath, new LinkOption[0]);
    }

    @Override
    public Class<Path> targetType() {
        return Path.class;
    }

    @Override
    public Optional<ConfigContent.NodeContent> load() throws ConfigException {
        if (!Files.exists(this.directoryPath, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            ConfigNode.ObjectNode.Builder objectNodeRoot = ConfigNode.ObjectNode.builder();
            Files.walk(this.directoryPath, 1, FileVisitOption.FOLLOW_LINKS).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                String content = FileSourceHelper.safeReadContent(path);
                objectNodeRoot.addValue(path.getFileName().toString(), content);
            });
            ConfigContent.NodeContent.Builder builder = ConfigContent.NodeContent.builder().node(objectNodeRoot.build());
            FileSourceHelper.lastModifiedTime(this.directoryPath).ifPresent(builder::stamp);
            return Optional.of(builder.build());
        }
        catch (ConfigException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigException("Configuration at directory '" + String.valueOf(this.directoryPath) + "' is not accessible.", ex);
        }
    }

    public static final class Builder
    extends AbstractConfigSourceBuilder<Builder, Path>
    implements PollableSource.Builder<Builder>,
    WatchableSource.Builder<Builder, Path>,
    io.helidon.common.Builder<Builder, DirectoryConfigSource> {
        private Path path;

        private Builder() {
        }

        @Override
        public DirectoryConfigSource build() {
            if (null == this.path) {
                throw new IllegalArgumentException("path must be defined");
            }
            return new DirectoryConfigSource(this);
        }

        @Override
        public Builder config(Config metaConfig) {
            metaConfig.get(DirectoryConfigSource.PATH_KEY).as(Path.class).ifPresent(this::path);
            return (Builder)super.config(metaConfig);
        }

        public Builder path(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public Builder changeWatcher(ChangeWatcher<Path> changeWatcher) {
            return (Builder)super.changeWatcher(changeWatcher);
        }

        @Override
        public Builder pollingStrategy(PollingStrategy pollingStrategy) {
            return (Builder)super.pollingStrategy(pollingStrategy);
        }
    }
}

