/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.config.GlobalConfig;
import io.helidon.config.Config;
import io.helidon.config.MetaConfig;
import io.helidon.config.MetaConfigFinder;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigMapperProvider;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.ConfigSource;
import io.helidon.service.registry.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Service.Singleton
class ConfigProvider
implements Supplier<io.helidon.common.config.Config> {
    private final io.helidon.common.config.Config config = GlobalConfig.configured() ? GlobalConfig.config() : Config.builder().update(it -> ((Optional)metaConfig.get()).ifPresent(metaConfigInstance -> it.config(metaConfigInstance.metaConfiguration()))).update(it -> ((List)configSources.get()).forEach(it::addSource)).update(it -> this.defaultConfigSources((Config.Builder)it, configParsers)).disableParserServices().update(it -> ((List)configParsers.get()).forEach(it::addParser)).disableFilterServices().update(it -> ((List)configFilters.get()).forEach(it::addFilter)).update(it -> ((List)configMappers.get()).forEach(it::addMapper)).build();

    @Service.Inject
    ConfigProvider(Supplier<Optional<MetaConfig>> metaConfig, Supplier<List<ConfigSource>> configSources, Supplier<List<ConfigParser>> configParsers, Supplier<List<ConfigFilter>> configFilters, Supplier<List<ConfigMapperProvider>> configMappers) {
    }

    @Override
    public io.helidon.common.config.Config get() {
        return this.config;
    }

    private void defaultConfigSources(Config.Builder configBuilder, Supplier<List<ConfigParser>> configParsers) {
        Set supportedSuffixes = configParsers.get().stream().map(ConfigParser::supportedSuffixes).flatMap(Collection::stream).collect(Collectors.toSet());
        MetaConfigFinder.profile().ifPresent(profile -> MetaConfigFinder.configSources(new ArrayList<String>(supportedSuffixes), profile));
        MetaConfigFinder.configSources(new ArrayList<String>(supportedSuffixes)).forEach(configBuilder::addSource);
    }
}

