/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigExistingImpl;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigFilter;
import io.helidon.config.spi.ConfigNode;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

abstract class ConfigComplexImpl<N extends ConfigNode>
extends ConfigExistingImpl<N> {
    ConfigComplexImpl(Config.Type type2, ConfigKeyImpl prefix, ConfigKeyImpl key, N node, ConfigFilter filter, ConfigFactory factory, ConfigMapperManager mapperManager) {
        super(type2, prefix, key, node, filter, factory, mapperManager);
    }

    @Override
    public <T> ConfigValue<List<T>> asList(Class<T> type2) throws ConfigMappingException {
        return ConfigValues.createList(this, config -> config.as(type2), config -> config.asList(type2));
    }

    @Override
    public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) throws ConfigMappingException {
        return ConfigValues.createList(this, config -> config.as(mapper), config -> config.asList(mapper));
    }

    @Override
    public final Stream<Config> traverse(Predicate<Config> predicate) {
        return this.asNodeList().map((? super T list) -> list.stream().filter(predicate).map((? super T node) -> this.traverseSubNodes((Config)node, predicate)).reduce(Stream.empty(), Stream::concat)).orElseThrow(MissingValueException.createSupplier(this.key()));
    }

    private Stream<Config> traverseSubNodes(Config config, Predicate<Config> predicate) {
        if (config.type().isLeaf()) {
            return Stream.of(config);
        }
        return config.asNodeList().map((? super T list) -> list.stream().filter(predicate).map((? super T node) -> this.traverseSubNodes((Config)node, predicate)).reduce(Stream.of(config), Stream::concat)).orElseThrow(MissingValueException.createSupplier(this.key()));
    }
}

