/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigDiff;
import io.helidon.config.ConfigFactory;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigMapperManager;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.spi.ConfigMapper;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

abstract class AbstractConfigImpl
implements Config {
    private final ConfigKeyImpl prefix;
    private final ConfigKeyImpl key;
    private final ConfigKeyImpl realKey;
    private final ConfigFactory factory;
    private final Config.Type type;
    private final Config.Context context;
    private final ConfigMapperManager mapperManager;

    AbstractConfigImpl(Config.Type type2, ConfigKeyImpl prefix, ConfigKeyImpl key, ConfigFactory factory, ConfigMapperManager mapperManager) {
        this.mapperManager = mapperManager;
        Objects.requireNonNull(prefix, "prefix argument is null.");
        Objects.requireNonNull(key, "key argument is null.");
        Objects.requireNonNull(factory, "factory argument is null.");
        this.prefix = prefix;
        this.key = key;
        this.realKey = prefix.child(key);
        this.factory = factory;
        this.type = type2;
        this.context = new NodeContextImpl();
    }

    Optional<String> value() {
        return Optional.empty();
    }

    @Override
    public Config.Context context() {
        return this.context;
    }

    @Override
    public final Instant timestamp() {
        return this.factory.timestamp();
    }

    @Override
    public final ConfigKeyImpl key() {
        return this.key;
    }

    protected final ConfigKeyImpl realKey() {
        return this.realKey;
    }

    @Override
    public final Config.Type type() {
        return this.type;
    }

    @Override
    public <T> T convert(Class<T> type2, String value) throws ConfigMappingException {
        return this.mapperManager.map(value, type2, this.key().toString());
    }

    @Override
    public Config root() {
        return this.factory.config(this.prefix, ConfigKeyImpl.of());
    }

    @Override
    public final Config get(Config.Key subKey) {
        Objects.requireNonNull(subKey, "Key argument is null.");
        if (subKey.isRoot()) {
            return this;
        }
        return this.factory.config(this.prefix, this.key.child(subKey));
    }

    @Override
    public final Config detach() {
        if (this.key.isRoot()) {
            return this;
        }
        return this.factory.config(this.realKey(), ConfigKeyImpl.of());
    }

    @Override
    public ConfigValue<List<Config>> asNodeList() throws ConfigMappingException {
        return this.asList(Config.class);
    }

    private Config contextConfig(Config rootConfig) {
        return rootConfig.get(this.prefix).detach().get(this.key);
    }

    @Override
    public void onChange(Consumer<Config> onChangeConsumer) {
        this.factory.provider().onChange((ConfigDiff event) -> {
            if (event.changedKeys().contains(this.realKey)) {
                onChangeConsumer.accept(this.contextConfig(event.config()));
            }
        });
    }

    @Override
    public ConfigMapper mapper() {
        return this.mapperManager;
    }

    private class NodeContextImpl
    implements Config.Context {
        private NodeContextImpl() {
        }

        @Override
        public Instant timestamp() {
            return AbstractConfigImpl.this.factory.context().timestamp();
        }

        @Override
        public Config last() {
            return AbstractConfigImpl.this.contextConfig(AbstractConfigImpl.this.factory.context().last());
        }

        @Override
        public Config reload() {
            return AbstractConfigImpl.this.contextConfig(AbstractConfigImpl.this.factory.context().reload());
        }
    }
}

