/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.ElementSignatures;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.common.types.TypedElementInfoBlueprint;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

final class TypedElementInfoSupport {
    private TypedElementInfoSupport() {
    }

    @Prototype.PrototypeMethod
    @Prototype.Annotated(value={"java.lang.Override"})
    static String toString(TypedElementInfo me) {
        StringBuilder builder = new StringBuilder();
        if (ElementKind.PARAMETER != me.kind()) {
            me.enclosingType().ifPresent(enclosingTypeName -> builder.append(enclosingTypeName).append("::"));
        }
        builder.append(me.toDeclaration());
        return builder.toString();
    }

    @Prototype.PrototypeMethod
    static String toDeclaration(TypedElementInfo me) {
        StringBuilder builder = new StringBuilder();
        builder.append(me.typeName()).append(" ").append(me.elementName());
        String params = me.parameterArguments().stream().map(it -> String.valueOf(it.typeName()) + " " + it.elementName()).collect(Collectors.joining(", "));
        if (!params.isBlank()) {
            builder.append("(").append(params).append(")");
        }
        return builder.toString();
    }

    static class BuilderDecorator
    implements Prototype.BuilderDecorator<TypedElementInfo.BuilderBase<?, ?>> {
        BuilderDecorator() {
        }

        @Override
        public void decorate(TypedElementInfo.BuilderBase<?, ?> target) {
            this.backwardCompatibility(target);
            this.constructorName(target);
            this.signature(target);
        }

        private void signature(TypedElementInfo.BuilderBase<?, ?> target) {
            if (target.kind().isEmpty()) {
                target.signature(ElementSignatures.createNone());
                return;
            }
            target.signature(this.signature(target, target.kind().get()));
        }

        private ElementSignature signature(TypedElementInfo.BuilderBase<?, ?> target, ElementKind elementKind) {
            if (elementKind == ElementKind.CONSTRUCTOR) {
                return ElementSignatures.createConstructor(this.toTypes(target.parameterArguments()));
            }
            if (target.typeName().isEmpty() || target.elementName().isEmpty()) {
                return ElementSignatures.createNone();
            }
            TypeName typeName = target.typeName().get();
            String name = target.elementName().get();
            if (elementKind == ElementKind.FIELD || elementKind == ElementKind.RECORD_COMPONENT || elementKind == ElementKind.ENUM_CONSTANT) {
                return ElementSignatures.createField(typeName, name);
            }
            if (elementKind == ElementKind.METHOD) {
                return ElementSignatures.createMethod(typeName, name, this.toTypes(target.parameterArguments()));
            }
            if (elementKind == ElementKind.PARAMETER) {
                return ElementSignatures.createParameter(typeName, name);
            }
            return ElementSignatures.createNone();
        }

        private List<TypeName> toTypes(List<TypedElementInfo> typedElementInfos) {
            return typedElementInfos.stream().map(TypedElementInfoBlueprint::typeName).collect(Collectors.toUnmodifiableList());
        }

        private void constructorName(TypedElementInfo.BuilderBase<?, ?> target) {
            Optional<ElementKind> elementKind = target.kind();
            if (elementKind.isPresent() && elementKind.get() == ElementKind.CONSTRUCTOR) {
                target.elementName("<init>");
            }
        }

        private void backwardCompatibility(TypedElementInfo.BuilderBase<?, ?> target) {
            if (target.kind().isEmpty() && target.elementTypeKind().isPresent()) {
                target.kind(ElementKind.valueOf(target.elementTypeKind().get().toUpperCase(Locale.ROOT)));
            }
            target.elementTypeKind(target.kind().get().toString());
            if (target.accessModifier().isEmpty()) {
                AccessModifier accessModifier = null;
                for (String modifier : target.modifiers()) {
                    if ("public".equals(modifier)) {
                        accessModifier = AccessModifier.PUBLIC;
                        break;
                    }
                    if ("protected".equals(modifier)) {
                        accessModifier = AccessModifier.PROTECTED;
                        break;
                    }
                    if (!"private".equals(modifier)) continue;
                    accessModifier = AccessModifier.PRIVATE;
                    break;
                }
                if (accessModifier == null) {
                    accessModifier = AccessModifier.PACKAGE_PRIVATE;
                }
                target.accessModifier(accessModifier);
            }
            for (String modifier : target.modifiers()) {
                try {
                    target.addElementModifier(Modifier.valueOf(modifier.toUpperCase(Locale.ROOT)));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            for (Modifier typeModifier : target.elementModifiers()) {
                target.addModifier(typeModifier.modifierName());
            }
            target.addModifier(target.accessModifier().get().modifierName());
        }
    }
}

