/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfoBlueprint;
import io.helidon.common.types.TypedElementInfoSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface TypedElementInfo
extends TypedElementInfoBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TypedElementInfo instance) {
        return (Builder)TypedElementInfo.builder().from(instance);
    }

    public String toDeclaration();

    public static class Builder
    extends BuilderBase<Builder, TypedElementInfo>
    implements io.helidon.common.Builder<Builder, TypedElementInfo> {
        private Builder() {
        }

        @Override
        public TypedElementInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.TypedElementInfoImpl(this);
        }

        @Override
        public TypedElementInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends TypedElementInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Annotation> annotations = new ArrayList<Annotation>();
        private final List<Annotation> elementTypeAnnotations = new ArrayList<Annotation>();
        private final List<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
        private final List<TypeName> componentTypes = new ArrayList<TypeName>();
        private final List<TypeName> typeParameters = new ArrayList<TypeName>();
        private final List<TypedElementInfo> parameterArguments = new ArrayList<TypedElementInfo>();
        private final Set<TypeName> throwsChecked = new LinkedHashSet<TypeName>();
        private final Set<Modifier> elementModifiers = new LinkedHashSet<Modifier>();
        private final Set<String> modifiers = new LinkedHashSet<String>();
        private AccessModifier accessModifier;
        private boolean isAnnotationsMutated;
        private boolean isComponentTypesMutated;
        private boolean isElementTypeAnnotationsMutated;
        private boolean isInheritedAnnotationsMutated;
        private boolean isParameterArgumentsMutated;
        private boolean isTypeParametersMutated;
        private ElementKind kind;
        private ElementSignature signature;
        private Object originatingElement;
        private String defaultValue;
        private String description;
        private String elementName;
        private String elementTypeKind;
        private TypeName enclosingType;
        private TypeName typeName;

        protected BuilderBase() {
        }

        public BUILDER from(TypedElementInfo prototype) {
            this.description(prototype.description());
            this.typeName(prototype.typeName());
            this.elementName(prototype.elementName());
            this.elementTypeKind(prototype.elementTypeKind());
            this.kind(prototype.kind());
            this.defaultValue(prototype.defaultValue());
            if (!this.isElementTypeAnnotationsMutated) {
                this.elementTypeAnnotations.clear();
            }
            this.addElementTypeAnnotations(prototype.elementTypeAnnotations());
            if (!this.isComponentTypesMutated) {
                this.componentTypes.clear();
            }
            this.addComponentTypes(prototype.componentTypes());
            this.addModifiers(prototype.modifiers());
            this.addElementModifiers(prototype.elementModifiers());
            this.accessModifier(prototype.accessModifier());
            this.enclosingType(prototype.enclosingType());
            if (!this.isParameterArgumentsMutated) {
                this.parameterArguments.clear();
            }
            this.addParameterArguments(prototype.parameterArguments());
            this.addThrowsChecked(prototype.throwsChecked());
            this.originatingElement(prototype.originatingElement());
            this.signature(prototype.signature());
            if (!this.isTypeParametersMutated) {
                this.typeParameters.clear();
            }
            this.addTypeParameters(prototype.typeParameters());
            if (!this.isAnnotationsMutated) {
                this.annotations.clear();
            }
            this.addAnnotations(prototype.annotations());
            if (!this.isInheritedAnnotationsMutated) {
                this.inheritedAnnotations.clear();
            }
            this.addInheritedAnnotations(prototype.inheritedAnnotations());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.description().ifPresent(this::description);
            builder.typeName().ifPresent(this::typeName);
            builder.elementName().ifPresent(this::elementName);
            builder.elementTypeKind().ifPresent(this::elementTypeKind);
            builder.kind().ifPresent(this::kind);
            builder.defaultValue().ifPresent(this::defaultValue);
            if (this.isElementTypeAnnotationsMutated) {
                if (builder.isElementTypeAnnotationsMutated) {
                    this.addElementTypeAnnotations(builder.elementTypeAnnotations);
                }
            } else {
                this.elementTypeAnnotations.clear();
                this.addElementTypeAnnotations(builder.elementTypeAnnotations);
            }
            if (this.isComponentTypesMutated) {
                if (builder.isComponentTypesMutated) {
                    this.addComponentTypes(builder.componentTypes);
                }
            } else {
                this.componentTypes.clear();
                this.addComponentTypes(builder.componentTypes);
            }
            this.addModifiers(builder.modifiers);
            this.addElementModifiers(builder.elementModifiers);
            builder.accessModifier().ifPresent(this::accessModifier);
            builder.enclosingType().ifPresent(this::enclosingType);
            if (this.isParameterArgumentsMutated) {
                if (builder.isParameterArgumentsMutated) {
                    this.addParameterArguments(builder.parameterArguments);
                }
            } else {
                this.parameterArguments.clear();
                this.addParameterArguments(builder.parameterArguments);
            }
            this.addThrowsChecked(builder.throwsChecked);
            builder.originatingElement().ifPresent(this::originatingElement);
            builder.signature().ifPresent(this::signature);
            if (this.isTypeParametersMutated) {
                if (builder.isTypeParametersMutated) {
                    this.addTypeParameters(builder.typeParameters);
                }
            } else {
                this.typeParameters.clear();
                this.addTypeParameters(builder.typeParameters);
            }
            if (this.isAnnotationsMutated) {
                if (builder.isAnnotationsMutated) {
                    this.addAnnotations(builder.annotations);
                }
            } else {
                this.annotations.clear();
                this.addAnnotations(builder.annotations);
            }
            if (this.isInheritedAnnotationsMutated) {
                if (builder.isInheritedAnnotationsMutated) {
                    this.addInheritedAnnotations(builder.inheritedAnnotations);
                }
            } else {
                this.inheritedAnnotations.clear();
                this.addInheritedAnnotations(builder.inheritedAnnotations);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDescription() {
            this.description = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(TypeName typeName) {
            Objects.requireNonNull(typeName);
            this.typeName = typeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.typeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.typeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementName(String elementName) {
            Objects.requireNonNull(elementName);
            this.elementName = elementName;
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.1.0", forRemoval=true)
        public BUILDER elementTypeKind(String elementTypeKind) {
            Objects.requireNonNull(elementTypeKind);
            this.elementTypeKind = elementTypeKind;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER kind(ElementKind kind) {
            Objects.requireNonNull(kind);
            this.kind = kind;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDefaultValue() {
            this.defaultValue = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER defaultValue(String defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValue = defaultValue;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementTypeAnnotations(List<? extends Annotation> elementTypeAnnotations) {
            Objects.requireNonNull(elementTypeAnnotations);
            this.isElementTypeAnnotationsMutated = true;
            this.elementTypeAnnotations.clear();
            this.elementTypeAnnotations.addAll(elementTypeAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementTypeAnnotations(List<? extends Annotation> elementTypeAnnotations) {
            Objects.requireNonNull(elementTypeAnnotations);
            this.isElementTypeAnnotationsMutated = true;
            this.elementTypeAnnotations.addAll(elementTypeAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER componentTypes(List<? extends TypeName> componentTypes) {
            Objects.requireNonNull(componentTypes);
            this.isComponentTypesMutated = true;
            this.componentTypes.clear();
            this.componentTypes.addAll(componentTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addComponentTypes(List<? extends TypeName> componentTypes) {
            Objects.requireNonNull(componentTypes);
            this.isComponentTypesMutated = true;
            this.componentTypes.addAll(componentTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER modifiers(Set<String> modifiers) {
            Objects.requireNonNull(modifiers);
            this.modifiers.clear();
            this.modifiers.addAll(modifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addModifiers(Set<String> modifiers) {
            Objects.requireNonNull(modifiers);
            this.modifiers.addAll(modifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.1.0", forRemoval=true)
        public BUILDER addModifier(String modifier) {
            Objects.requireNonNull(modifier);
            this.modifiers.add(modifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementModifiers(Set<? extends Modifier> elementModifiers) {
            Objects.requireNonNull(elementModifiers);
            this.elementModifiers.clear();
            this.elementModifiers.addAll(elementModifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementModifiers(Set<? extends Modifier> elementModifiers) {
            Objects.requireNonNull(elementModifiers);
            this.elementModifiers.addAll(elementModifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementModifier(Modifier elementModifier) {
            Objects.requireNonNull(elementModifier);
            this.elementModifiers.add(elementModifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER accessModifier(AccessModifier accessModifier) {
            Objects.requireNonNull(accessModifier);
            this.accessModifier = accessModifier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearEnclosingType() {
            this.enclosingType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enclosingType(TypeName enclosingType) {
            Objects.requireNonNull(enclosingType);
            this.enclosingType = enclosingType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enclosingType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.enclosingType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameterArguments(List<? extends TypedElementInfo> parameterArguments) {
            Objects.requireNonNull(parameterArguments);
            this.isParameterArgumentsMutated = true;
            this.parameterArguments.clear();
            this.parameterArguments.addAll(parameterArguments);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addParameterArguments(List<? extends TypedElementInfo> parameterArguments) {
            Objects.requireNonNull(parameterArguments);
            this.isParameterArgumentsMutated = true;
            this.parameterArguments.addAll(parameterArguments);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addParameterArgument(TypedElementInfo parameterArgument) {
            Objects.requireNonNull(parameterArgument);
            this.parameterArguments.add(parameterArgument);
            this.isParameterArgumentsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addParameterArgument(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.parameterArguments.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER throwsChecked(Set<? extends TypeName> throwsChecked) {
            Objects.requireNonNull(throwsChecked);
            this.throwsChecked.clear();
            this.throwsChecked.addAll(throwsChecked);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addThrowsChecked(Set<? extends TypeName> throwsChecked) {
            Objects.requireNonNull(throwsChecked);
            this.throwsChecked.addAll(throwsChecked);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOriginatingElement() {
            this.originatingElement = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER originatingElement(Object originatingElement) {
            Objects.requireNonNull(originatingElement);
            this.originatingElement = originatingElement;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeParameters(List<? extends TypeName> typeParameters) {
            Objects.requireNonNull(typeParameters);
            this.isTypeParametersMutated = true;
            this.typeParameters.clear();
            this.typeParameters.addAll(typeParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTypeParameters(List<? extends TypeName> typeParameters) {
            Objects.requireNonNull(typeParameters);
            this.isTypeParametersMutated = true;
            this.typeParameters.addAll(typeParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTypeParameter(TypeName typeParameter) {
            Objects.requireNonNull(typeParameter);
            this.typeParameters.add(typeParameter);
            this.isTypeParametersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTypeParameter(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.typeParameters.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER annotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.clear();
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation);
            this.annotations.add(annotation);
            this.isAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.annotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER inheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.clear();
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Annotation inheritedAnnotation) {
            Objects.requireNonNull(inheritedAnnotation);
            this.inheritedAnnotations.add(inheritedAnnotation);
            this.isInheritedAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.inheritedAnnotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public Optional<TypeName> typeName() {
            return Optional.ofNullable(this.typeName);
        }

        public Optional<String> elementName() {
            return Optional.ofNullable(this.elementName);
        }

        @Deprecated(since="4.1.0", forRemoval=true)
        public Optional<String> elementTypeKind() {
            return Optional.ofNullable(this.elementTypeKind);
        }

        public Optional<ElementKind> kind() {
            return Optional.ofNullable(this.kind);
        }

        public Optional<String> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }

        public List<Annotation> elementTypeAnnotations() {
            return this.elementTypeAnnotations;
        }

        public List<TypeName> componentTypes() {
            return this.componentTypes;
        }

        @Deprecated(since="4.1.0", forRemoval=true)
        public Set<String> modifiers() {
            return this.modifiers;
        }

        public Set<Modifier> elementModifiers() {
            return this.elementModifiers;
        }

        public Optional<AccessModifier> accessModifier() {
            return Optional.ofNullable(this.accessModifier);
        }

        public Optional<TypeName> enclosingType() {
            return Optional.ofNullable(this.enclosingType);
        }

        public List<TypedElementInfo> parameterArguments() {
            return this.parameterArguments;
        }

        public Set<TypeName> throwsChecked() {
            return this.throwsChecked;
        }

        public Optional<Object> originatingElement() {
            return Optional.ofNullable(this.originatingElement);
        }

        public Optional<ElementSignature> signature() {
            return Optional.ofNullable(this.signature);
        }

        public List<TypeName> typeParameters() {
            return this.typeParameters;
        }

        public List<Annotation> annotations() {
            return this.annotations;
        }

        public List<Annotation> inheritedAnnotations() {
            return this.inheritedAnnotations;
        }

        protected void preBuildPrototype() {
            new TypedElementInfoSupport.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.typeName == null) {
                collector.fatal(this.getClass(), "Property \"typeName\" is required, but not set");
            }
            if (this.elementName == null) {
                collector.fatal(this.getClass(), "Property \"elementName\" is required, but not set");
            }
            if (this.elementTypeKind == null) {
                collector.fatal(this.getClass(), "Property \"elementTypeKind\" is required, but not set");
            }
            if (this.kind == null) {
                collector.fatal(this.getClass(), "Property \"kind\" must not be null, but not set");
            }
            if (this.accessModifier == null) {
                collector.fatal(this.getClass(), "Property \"accessModifier\" must not be null, but not set");
            }
            if (this.signature == null) {
                collector.fatal(this.getClass(), "Property \"signature\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER description(Optional<String> description) {
            Objects.requireNonNull(description);
            this.description = description.map(String.class::cast).orElse(this.description);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER defaultValue(Optional<String> defaultValue) {
            Objects.requireNonNull(defaultValue);
            this.defaultValue = defaultValue.map(String.class::cast).orElse(this.defaultValue);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER enclosingType(Optional<? extends TypeName> enclosingType) {
            Objects.requireNonNull(enclosingType);
            this.enclosingType = enclosingType.map(TypeName.class::cast).orElse(this.enclosingType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER originatingElement(Optional<?> originatingElement) {
            Objects.requireNonNull(originatingElement);
            this.originatingElement = originatingElement.map(Object.class::cast).orElse(this.originatingElement);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER signature(ElementSignature signature) {
            Objects.requireNonNull(signature);
            this.signature = signature;
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class TypedElementInfoImpl
        implements TypedElementInfo {
            private final AccessModifier accessModifier;
            private final ElementKind kind;
            private final ElementSignature signature;
            private final List<Annotation> annotations;
            private final List<Annotation> elementTypeAnnotations;
            private final List<Annotation> inheritedAnnotations;
            private final List<TypeName> componentTypes;
            private final List<TypeName> typeParameters;
            private final List<TypedElementInfo> parameterArguments;
            private final Optional<TypeName> enclosingType;
            private final Optional<Object> originatingElement;
            private final Optional<String> defaultValue;
            private final Optional<String> description;
            private final Set<TypeName> throwsChecked;
            private final Set<Modifier> elementModifiers;
            private final Set<String> modifiers;
            private final String elementName;
            private final String elementTypeKind;
            private final TypeName typeName;

            protected TypedElementInfoImpl(BuilderBase<?, ?> builder) {
                this.description = builder.description();
                this.typeName = builder.typeName().get();
                this.elementName = builder.elementName().get();
                this.elementTypeKind = builder.elementTypeKind().get();
                this.kind = builder.kind().get();
                this.defaultValue = builder.defaultValue();
                this.elementTypeAnnotations = List.copyOf(builder.elementTypeAnnotations());
                this.componentTypes = List.copyOf(builder.componentTypes());
                this.modifiers = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.modifiers()));
                this.elementModifiers = Collections.unmodifiableSet(new LinkedHashSet<Modifier>(builder.elementModifiers()));
                this.accessModifier = builder.accessModifier().get();
                this.enclosingType = builder.enclosingType();
                this.parameterArguments = List.copyOf(builder.parameterArguments());
                this.throwsChecked = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.throwsChecked()));
                this.originatingElement = builder.originatingElement();
                this.signature = builder.signature().get();
                this.typeParameters = List.copyOf(builder.typeParameters());
                this.annotations = List.copyOf(builder.annotations());
                this.inheritedAnnotations = List.copyOf(builder.inheritedAnnotations());
            }

            public String toString() {
                return TypedElementInfoSupport.toString(this);
            }

            @Override
            public String toDeclaration() {
                return TypedElementInfoSupport.toDeclaration(this);
            }

            @Override
            public Optional<String> description() {
                return this.description;
            }

            @Override
            public TypeName typeName() {
                return this.typeName;
            }

            @Override
            public String elementName() {
                return this.elementName;
            }

            @Override
            public String elementTypeKind() {
                return this.elementTypeKind;
            }

            @Override
            public ElementKind kind() {
                return this.kind;
            }

            @Override
            public Optional<String> defaultValue() {
                return this.defaultValue;
            }

            @Override
            public List<Annotation> elementTypeAnnotations() {
                return this.elementTypeAnnotations;
            }

            @Override
            public List<TypeName> componentTypes() {
                return this.componentTypes;
            }

            @Override
            public Set<String> modifiers() {
                return this.modifiers;
            }

            @Override
            public Set<Modifier> elementModifiers() {
                return this.elementModifiers;
            }

            @Override
            public AccessModifier accessModifier() {
                return this.accessModifier;
            }

            @Override
            public Optional<TypeName> enclosingType() {
                return this.enclosingType;
            }

            @Override
            public List<TypedElementInfo> parameterArguments() {
                return this.parameterArguments;
            }

            @Override
            public Set<TypeName> throwsChecked() {
                return this.throwsChecked;
            }

            @Override
            public Optional<Object> originatingElement() {
                return this.originatingElement;
            }

            @Override
            public ElementSignature signature() {
                return this.signature;
            }

            @Override
            public List<TypeName> typeParameters() {
                return this.typeParameters;
            }

            @Override
            public List<Annotation> annotations() {
                return this.annotations;
            }

            @Override
            public List<Annotation> inheritedAnnotations() {
                return this.inheritedAnnotations;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TypedElementInfo)) {
                    return false;
                }
                TypedElementInfo other = (TypedElementInfo)o;
                return Objects.equals(this.typeName, other.typeName()) && Objects.equals(this.elementName, other.elementName()) && Objects.equals((Object)this.kind, (Object)other.kind()) && Objects.equals(this.enclosingType, other.enclosingType()) && Objects.equals(this.parameterArguments, other.parameterArguments()) && Objects.equals(this.throwsChecked, other.throwsChecked()) && Objects.equals(this.signature, other.signature()) && Objects.equals(this.typeParameters, other.typeParameters()) && Objects.equals(this.annotations, other.annotations()) && Objects.equals(this.inheritedAnnotations, other.inheritedAnnotations());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.typeName, this.elementName, this.kind, this.enclosingType, this.parameterArguments, this.throwsChecked, this.signature, this.typeParameters, this.annotations, this.inheritedAnnotations});
            }
        }
    }
}

