/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.GenericType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TypeNameSupport {
    private static final TypeName PRIMITIVE_BOOLEAN = TypeName.create(Boolean.TYPE);
    private static final TypeName PRIMITIVE_BYTE = TypeName.create(Byte.TYPE);
    private static final TypeName PRIMITIVE_SHORT = TypeName.create(Short.TYPE);
    private static final TypeName PRIMITIVE_INT = TypeName.create(Integer.TYPE);
    private static final TypeName PRIMITIVE_LONG = TypeName.create(Long.TYPE);
    private static final TypeName PRIMITIVE_CHAR = TypeName.create(Character.TYPE);
    private static final TypeName PRIMITIVE_FLOAT = TypeName.create(Float.TYPE);
    private static final TypeName PRIMITIVE_DOUBLE = TypeName.create(Double.TYPE);
    private static final TypeName PRIMITIVE_VOID = TypeName.create(Void.TYPE);
    private static final TypeName BOXED_BOOLEAN = TypeName.create(Boolean.class);
    private static final TypeName BOXED_BYTE = TypeName.create(Byte.class);
    private static final TypeName BOXED_SHORT = TypeName.create(Short.class);
    private static final TypeName BOXED_INT = TypeName.create(Integer.class);
    private static final TypeName BOXED_LONG = TypeName.create(Long.class);
    private static final TypeName BOXED_CHAR = TypeName.create(Character.class);
    private static final TypeName BOXED_FLOAT = TypeName.create(Float.class);
    private static final TypeName BOXED_DOUBLE = TypeName.create(Double.class);
    private static final TypeName BOXED_VOID = TypeName.create(Void.class);
    private static final Map<String, TypeName> PRIMITIVES = Map.of("boolean", PRIMITIVE_BOOLEAN, "byte", PRIMITIVE_BYTE, "short", PRIMITIVE_SHORT, "int", PRIMITIVE_INT, "long", PRIMITIVE_LONG, "char", PRIMITIVE_CHAR, "float", PRIMITIVE_FLOAT, "double", PRIMITIVE_DOUBLE, "void", PRIMITIVE_VOID);
    private static final Map<TypeName, TypeName> BOXED_TYPES = Map.of(PRIMITIVE_BOOLEAN, BOXED_BOOLEAN, PRIMITIVE_BYTE, BOXED_BYTE, PRIMITIVE_SHORT, BOXED_SHORT, PRIMITIVE_INT, BOXED_INT, PRIMITIVE_LONG, BOXED_LONG, PRIMITIVE_CHAR, BOXED_CHAR, PRIMITIVE_FLOAT, BOXED_FLOAT, PRIMITIVE_DOUBLE, BOXED_DOUBLE, PRIMITIVE_VOID, BOXED_VOID);

    private TypeNameSupport() {
    }

    @Prototype.PrototypeMethod
    @Prototype.Annotated(value={"java.lang.Override"})
    static int compareTo(TypeName typeName, TypeName o) {
        int diff = typeName.name().compareTo(o.name());
        if (diff != 0) {
            return diff;
        }
        diff = Boolean.compare(typeName.primitive(), o.primitive());
        if (diff != 0) {
            return diff;
        }
        return Boolean.compare(typeName.array(), o.array());
    }

    @Prototype.PrototypeMethod
    static TypeName boxed(TypeName original) {
        return Optional.ofNullable(BOXED_TYPES.get(original)).orElse(original);
    }

    @Prototype.PrototypeMethod
    @Prototype.Annotated(value={"java.lang.Override"})
    static String toString(TypeName instance) {
        return instance.resolvedName();
    }

    @Prototype.PrototypeMethod
    @Prototype.Annotated(value={"java.lang.Override"})
    static String name(TypeName instance) {
        return TypeNameSupport.calcName(instance, "$");
    }

    @Prototype.PrototypeMethod
    static TypeName genericTypeName(TypeName instance) {
        return ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder(instance).typeArguments(List.of())).generic(false)).array(false)).build();
    }

    @Prototype.PrototypeMethod
    @Prototype.Annotated(value={"java.lang.Override"})
    static String fqName(TypeName instance) {
        String name = TypeNameSupport.calcName(instance, ".");
        StringBuilder nameBuilder = new StringBuilder(instance.wildcard() ? "?" : name);
        if (instance.array()) {
            nameBuilder.append("[]");
        }
        return nameBuilder.toString();
    }

    @Prototype.PrototypeMethod
    @Prototype.Annotated(value={"java.lang.Override"})
    static String resolvedName(TypeName instance) {
        if (instance.generic() || instance.wildcard()) {
            return TypeNameSupport.resolveGenericName(instance);
        }
        return TypeNameSupport.resolveClassName(instance);
    }

    @Prototype.BuilderMethod
    static void type(TypeName.BuilderBase<?, ?> builder, Type type2) {
        Objects.requireNonNull(type2);
        if (type2 instanceof Class) {
            Class classType = (Class)type2;
            TypeNameSupport.updateFromClass(builder, classType);
            return;
        }
        Type reflectGenericType = type2;
        if (type2 instanceof GenericType) {
            GenericType gt = (GenericType)type2;
            if (gt.isClass()) {
                TypeNameSupport.updateFromClass(builder, gt.rawType());
                return;
            }
            reflectGenericType = gt.type();
        }
        if (reflectGenericType instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            ParameterizedType pt = (ParameterizedType)reflectGenericType;
            Type raw = pt.getRawType();
            if (!(raw instanceof Class)) {
                throw new IllegalArgumentException("Raw type of a ParameterizedType is not a class: " + raw.getClass().getName() + ", for " + pt.getTypeName());
            }
            Class theClass = (Class)raw;
            TypeNameSupport.updateFromClass(builder, theClass);
            for (Type actualTypeArgument : actualTypeArguments = pt.getActualTypeArguments()) {
                builder.addTypeArgument(TypeName.create(actualTypeArgument));
            }
            return;
        }
        if (reflectGenericType instanceof WildcardType) {
            builder.className("?");
            builder.wildcard(true);
            return;
        }
        if (reflectGenericType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)reflectGenericType;
            for (Type bound : tv.getBounds()) {
                builder.addUpperBound(TypeName.create(bound));
            }
            ((TypeName.BuilderBase)builder.className(tv.getName())).generic(true);
            return;
        }
        if (reflectGenericType instanceof GenericArrayType) {
            GenericArrayType ga = (GenericArrayType)reflectGenericType;
            TypeName componentType = TypeName.create(ga.getGenericComponentType());
            ((TypeName.BuilderBase)builder.from(componentType)).array(true);
            return;
        }
        throw new IllegalArgumentException("We can only create a type from a class, GenericType, or a ParameterizedType, but got: " + reflectGenericType.getClass().getName());
    }

    @Prototype.FactoryMethod
    static TypeName create(Type type2) {
        return ((TypeName.Builder)TypeName.builder().type(type2)).build();
    }

    @Prototype.FactoryMethod
    static TypeName create(String typeName) {
        Objects.requireNonNull(typeName);
        if (typeName.startsWith("?")) {
            if (typeName.startsWith("? extends ")) {
                return ((TypeName.Builder)TypeName.builder(TypeNameSupport.create(typeName.substring(10).trim())).wildcard(true)).build();
            }
            return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type((Type)((Object)Object.class))).wildcard(true)).build();
        }
        TypeName primitive = PRIMITIVES.get(typeName);
        if (primitive != null) {
            return primitive;
        }
        TypeName.Builder builder = TypeName.builder();
        int index = typeName.indexOf(60);
        if (index > 0) {
            String genericSection = typeName.substring(index + 1, typeName.length() - 1);
            typeName = typeName.substring(0, index);
            Stream.of(genericSection.split(",")).map(String::trim).map(it -> {
                if (it.contains(".")) {
                    return TypeName.create(it);
                }
                return TypeName.createFromGenericDeclaration(it);
            }).forEach(builder::addTypeArgument);
        }
        String className = typeName;
        ArrayList<String> packageElements = new ArrayList<String>();
        while (true) {
            int dot;
            if (className.isEmpty()) {
                throw new IllegalArgumentException("Invalid type name: \"" + typeName + "\", got empty string section");
            }
            if (Character.isUpperCase(className.charAt(0)) || (dot = className.indexOf(46)) == -1) break;
            packageElements.add(className.substring(0, dot));
            className = className.substring(dot + 1);
        }
        String packageName = String.join((CharSequence)".", packageElements);
        String[] types = className.split("\\.");
        return ((TypeName.Builder)((TypeName.Builder)builder.packageName(packageName)).update(it -> {
            for (int i = 0; i < types.length - 1; ++i) {
                it.addEnclosingName(types[i]);
            }
        }).className(types[types.length - 1])).build();
    }

    @Prototype.FactoryMethod
    static TypeName createFromGenericDeclaration(String genericAliasTypeName) {
        return ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().generic(true)).className(Objects.requireNonNull(genericAliasTypeName))).wildcard(genericAliasTypeName.startsWith("?"))).build();
    }

    private static String resolveGenericName(TypeName instance) {
        String prefix;
        String string = prefix = instance.wildcard() ? "?" : instance.className();
        if (instance.upperBounds().isEmpty() && instance.lowerBounds().isEmpty()) {
            return prefix;
        }
        if (instance.lowerBounds().isEmpty()) {
            return prefix + " extends " + instance.upperBounds().stream().map(it -> {
                if (it.generic()) {
                    return it.wildcard() ? "?" : it.className();
                }
                return it.resolvedName();
            }).collect(Collectors.joining(" & "));
        }
        TypeName lowerBound = instance.lowerBounds().getFirst();
        if (lowerBound.generic()) {
            return prefix + " super " + (lowerBound.wildcard() ? "?" : lowerBound.className());
        }
        return prefix + " super " + lowerBound.resolvedName();
    }

    private static String resolveClassName(TypeName instance) {
        String name = TypeNameSupport.calcName(instance, ".");
        StringBuilder nameBuilder = new StringBuilder(name);
        if (!instance.typeArguments().isEmpty()) {
            nameBuilder.append("<");
            int i = 0;
            for (TypeName param : instance.typeArguments()) {
                if (i > 0) {
                    nameBuilder.append(", ");
                }
                nameBuilder.append(param.resolvedName());
                ++i;
            }
            nameBuilder.append(">");
        }
        if (instance.array()) {
            nameBuilder.append("[]");
        }
        return nameBuilder.toString();
    }

    private static void updateFromClass(TypeName.BuilderBase<?, ?> builder, Class<?> classType) {
        Class<?> componentType = classType.isArray() ? classType.getComponentType() : classType;
        builder.packageName(componentType.getPackageName());
        builder.className(componentType.getSimpleName());
        builder.primitive(componentType.isPrimitive());
        builder.array(classType.isArray());
        LinkedList<String> enclosingTypes = new LinkedList<String>();
        for (Class<?> enclosingClass = classType.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
            enclosingTypes.addFirst(enclosingClass.getSimpleName());
        }
        builder.enclosingNames(enclosingTypes);
    }

    private static String calcName(TypeName instance, String typeSeparator) {
        Object className = instance.enclosingNames().isEmpty() ? instance.className() : String.join((CharSequence)typeSeparator, instance.enclosingNames()) + typeSeparator + instance.className();
        return instance.primitive() || instance.packageName().isEmpty() ? className : instance.packageName() + "." + (String)className;
    }

    static class Decorator
    implements Prototype.BuilderDecorator<TypeName.BuilderBase<?, ?>> {
        Decorator() {
        }

        @Override
        public void decorate(TypeName.BuilderBase<?, ?> target) {
            this.fixWildcards(target);
        }

        private void fixWildcards(TypeName.BuilderBase<?, ?> target) {
            if (target.wildcard()) {
                TypeName upperBound;
                if (target.upperBounds().size() == 1 && target.lowerBounds().isEmpty()) {
                    upperBound = target.upperBounds().getFirst();
                    target.className(upperBound.className());
                    target.packageName(upperBound.packageName());
                    target.enclosingNames(upperBound.enclosingNames());
                }
                if (target.className().isPresent() && !target.className().get().equals("?") && target.upperBounds().isEmpty() && target.lowerBounds().isEmpty() && !(upperBound = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(target)).wildcard(false)).build()).equals(TypeNames.OBJECT)) {
                    target.addUpperBound(upperBound);
                }
                target.generic(true);
            }
        }
    }
}

