/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.TypeNameBlueprint;
import io.helidon.common.types.TypeNameSupport;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public interface TypeName
extends TypeNameBlueprint,
Prototype.Api,
Comparable<TypeName> {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TypeName instance) {
        return (Builder)TypeName.builder().from(instance);
    }

    public static TypeName create(Type type2) {
        return TypeNameSupport.create(type2);
    }

    public static TypeName create(String typeName) {
        return TypeNameSupport.create(typeName);
    }

    public static TypeName createFromGenericDeclaration(String genericAliasTypeName) {
        return TypeNameSupport.createFromGenericDeclaration(genericAliasTypeName);
    }

    public TypeName boxed();

    public TypeName genericTypeName();

    public static class Builder
    extends BuilderBase<Builder, TypeName>
    implements io.helidon.common.Builder<Builder, TypeName> {
        private Builder() {
        }

        @Override
        public TypeName buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.TypeNameImpl(this);
        }

        @Override
        public TypeName build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends TypeName>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<TypeName> lowerBounds = new ArrayList<TypeName>();
        private final List<TypeName> typeArguments = new ArrayList<TypeName>();
        private final List<TypeName> upperBounds = new ArrayList<TypeName>();
        private final List<String> enclosingNames = new ArrayList<String>();
        private final List<String> typeParameters = new ArrayList<String>();
        private boolean array = false;
        private boolean generic = false;
        private boolean isEnclosingNamesMutated;
        private boolean isLowerBoundsMutated;
        private boolean isTypeArgumentsMutated;
        private boolean isTypeParametersMutated;
        private boolean isUpperBoundsMutated;
        private boolean primitive = false;
        private boolean wildcard = false;
        private String className;
        private String packageName = "";

        protected BuilderBase() {
        }

        public BUILDER from(TypeName prototype) {
            this.packageName(prototype.packageName());
            this.className(prototype.className());
            if (!this.isEnclosingNamesMutated) {
                this.enclosingNames.clear();
            }
            this.addEnclosingNames(prototype.enclosingNames());
            this.primitive(prototype.primitive());
            this.array(prototype.array());
            this.generic(prototype.generic());
            this.wildcard(prototype.wildcard());
            if (!this.isTypeArgumentsMutated) {
                this.typeArguments.clear();
            }
            this.addTypeArguments(prototype.typeArguments());
            if (!this.isTypeParametersMutated) {
                this.typeParameters.clear();
            }
            this.addTypeParameters(prototype.typeParameters());
            if (!this.isLowerBoundsMutated) {
                this.lowerBounds.clear();
            }
            this.addLowerBounds(prototype.lowerBounds());
            if (!this.isUpperBoundsMutated) {
                this.upperBounds.clear();
            }
            this.addUpperBounds(prototype.upperBounds());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.packageName(builder.packageName());
            builder.className().ifPresent(this::className);
            if (this.isEnclosingNamesMutated) {
                if (builder.isEnclosingNamesMutated) {
                    this.addEnclosingNames(builder.enclosingNames);
                }
            } else {
                this.enclosingNames.clear();
                this.addEnclosingNames(builder.enclosingNames);
            }
            this.primitive(builder.primitive());
            this.array(builder.array());
            this.generic(builder.generic());
            this.wildcard(builder.wildcard());
            if (this.isTypeArgumentsMutated) {
                if (builder.isTypeArgumentsMutated) {
                    this.addTypeArguments(builder.typeArguments);
                }
            } else {
                this.typeArguments.clear();
                this.addTypeArguments(builder.typeArguments);
            }
            if (this.isTypeParametersMutated) {
                if (builder.isTypeParametersMutated) {
                    this.addTypeParameters(builder.typeParameters);
                }
            } else {
                this.typeParameters.clear();
                this.addTypeParameters(builder.typeParameters);
            }
            if (this.isLowerBoundsMutated) {
                if (builder.isLowerBoundsMutated) {
                    this.addLowerBounds(builder.lowerBounds);
                }
            } else {
                this.lowerBounds.clear();
                this.addLowerBounds(builder.lowerBounds);
            }
            if (this.isUpperBoundsMutated) {
                if (builder.isUpperBoundsMutated) {
                    this.addUpperBounds(builder.upperBounds);
                }
            } else {
                this.upperBounds.clear();
                this.addUpperBounds(builder.upperBounds);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER type(Type type2) {
            TypeNameSupport.type(this, type2);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER packageName(String packageName) {
            Objects.requireNonNull(packageName);
            this.packageName = packageName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER className(String className) {
            Objects.requireNonNull(className);
            this.className = className;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enclosingNames(List<? extends String> enclosingNames) {
            Objects.requireNonNull(enclosingNames);
            this.isEnclosingNamesMutated = true;
            this.enclosingNames.clear();
            this.enclosingNames.addAll(enclosingNames);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addEnclosingNames(List<? extends String> enclosingNames) {
            Objects.requireNonNull(enclosingNames);
            this.isEnclosingNamesMutated = true;
            this.enclosingNames.addAll(enclosingNames);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addEnclosingName(String enclosingName) {
            Objects.requireNonNull(enclosingName);
            this.enclosingNames.add(enclosingName);
            this.isEnclosingNamesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER primitive(boolean primitive) {
            this.primitive = primitive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER array(boolean array) {
            this.array = array;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER generic(boolean generic) {
            this.generic = generic;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER wildcard(boolean wildcard) {
            this.wildcard = wildcard;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeArguments(List<? extends TypeName> typeArguments) {
            Objects.requireNonNull(typeArguments);
            this.isTypeArgumentsMutated = true;
            this.typeArguments.clear();
            this.typeArguments.addAll(typeArguments);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTypeArguments(List<? extends TypeName> typeArguments) {
            Objects.requireNonNull(typeArguments);
            this.isTypeArgumentsMutated = true;
            this.typeArguments.addAll(typeArguments);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTypeArgument(TypeName typeArgument) {
            Objects.requireNonNull(typeArgument);
            this.typeArguments.add(typeArgument);
            this.isTypeArgumentsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTypeArgument(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.typeArguments.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeParameters(List<? extends String> typeParameters) {
            Objects.requireNonNull(typeParameters);
            this.isTypeParametersMutated = true;
            this.typeParameters.clear();
            this.typeParameters.addAll(typeParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addTypeParameters(List<? extends String> typeParameters) {
            Objects.requireNonNull(typeParameters);
            this.isTypeParametersMutated = true;
            this.typeParameters.addAll(typeParameters);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public BUILDER addTypeParameter(String typeParameter) {
            Objects.requireNonNull(typeParameter);
            this.typeParameters.add(typeParameter);
            this.isTypeParametersMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER lowerBounds(List<? extends TypeName> lowerBounds) {
            Objects.requireNonNull(lowerBounds);
            this.isLowerBoundsMutated = true;
            this.lowerBounds.clear();
            this.lowerBounds.addAll(lowerBounds);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addLowerBounds(List<? extends TypeName> lowerBounds) {
            Objects.requireNonNull(lowerBounds);
            this.isLowerBoundsMutated = true;
            this.lowerBounds.addAll(lowerBounds);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addLowerBound(TypeName lowerBound) {
            Objects.requireNonNull(lowerBound);
            this.lowerBounds.add(lowerBound);
            this.isLowerBoundsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addLowerBound(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.lowerBounds.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER upperBounds(List<? extends TypeName> upperBounds) {
            Objects.requireNonNull(upperBounds);
            this.isUpperBoundsMutated = true;
            this.upperBounds.clear();
            this.upperBounds.addAll(upperBounds);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addUpperBounds(List<? extends TypeName> upperBounds) {
            Objects.requireNonNull(upperBounds);
            this.isUpperBoundsMutated = true;
            this.upperBounds.addAll(upperBounds);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addUpperBound(TypeName upperBound) {
            Objects.requireNonNull(upperBound);
            this.upperBounds.add(upperBound);
            this.isUpperBoundsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addUpperBound(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.upperBounds.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public String packageName() {
            return this.packageName;
        }

        public Optional<String> className() {
            return Optional.ofNullable(this.className);
        }

        public List<String> enclosingNames() {
            return this.enclosingNames;
        }

        public boolean primitive() {
            return this.primitive;
        }

        public boolean array() {
            return this.array;
        }

        public boolean generic() {
            return this.generic;
        }

        public boolean wildcard() {
            return this.wildcard;
        }

        public List<TypeName> typeArguments() {
            return this.typeArguments;
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public List<String> typeParameters() {
            return this.typeParameters;
        }

        public List<TypeName> lowerBounds() {
            return this.lowerBounds;
        }

        public List<TypeName> upperBounds() {
            return this.upperBounds;
        }

        protected void preBuildPrototype() {
            new TypeNameSupport.Decorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.className == null) {
                collector.fatal(this.getClass(), "Property \"className\" is required, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class TypeNameImpl
        implements TypeName {
            private final boolean array;
            private final boolean generic;
            private final boolean primitive;
            private final boolean wildcard;
            private final List<TypeName> lowerBounds;
            private final List<TypeName> typeArguments;
            private final List<TypeName> upperBounds;
            private final List<String> enclosingNames;
            private final List<String> typeParameters;
            private final String className;
            private final String packageName;

            protected TypeNameImpl(BuilderBase<?, ?> builder) {
                this.packageName = builder.packageName();
                this.className = builder.className().get();
                this.enclosingNames = List.copyOf(builder.enclosingNames());
                this.primitive = builder.primitive();
                this.array = builder.array();
                this.generic = builder.generic();
                this.wildcard = builder.wildcard();
                this.typeArguments = List.copyOf(builder.typeArguments());
                this.typeParameters = List.copyOf(builder.typeParameters());
                this.lowerBounds = List.copyOf(builder.lowerBounds());
                this.upperBounds = List.copyOf(builder.upperBounds());
            }

            @Override
            public int compareTo(TypeName o) {
                return TypeNameSupport.compareTo(this, o);
            }

            @Override
            public TypeName boxed() {
                return TypeNameSupport.boxed(this);
            }

            public String toString() {
                return TypeNameSupport.toString(this);
            }

            @Override
            public String name() {
                return TypeNameSupport.name(this);
            }

            @Override
            public TypeName genericTypeName() {
                return TypeNameSupport.genericTypeName(this);
            }

            @Override
            public String fqName() {
                return TypeNameSupport.fqName(this);
            }

            @Override
            public String resolvedName() {
                return TypeNameSupport.resolvedName(this);
            }

            @Override
            public String packageName() {
                return this.packageName;
            }

            @Override
            public String className() {
                return this.className;
            }

            @Override
            public List<String> enclosingNames() {
                return this.enclosingNames;
            }

            @Override
            public boolean primitive() {
                return this.primitive;
            }

            @Override
            public boolean array() {
                return this.array;
            }

            @Override
            public boolean generic() {
                return this.generic;
            }

            @Override
            public boolean wildcard() {
                return this.wildcard;
            }

            @Override
            public List<TypeName> typeArguments() {
                return this.typeArguments;
            }

            @Override
            public List<String> typeParameters() {
                return this.typeParameters;
            }

            @Override
            public List<TypeName> lowerBounds() {
                return this.lowerBounds;
            }

            @Override
            public List<TypeName> upperBounds() {
                return this.upperBounds;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TypeName)) {
                    return false;
                }
                TypeName other = (TypeName)o;
                return Objects.equals(this.packageName, other.packageName()) && Objects.equals(this.className, other.className()) && Objects.equals(this.enclosingNames, other.enclosingNames()) && this.primitive == other.primitive() && this.array == other.array();
            }

            public int hashCode() {
                return Objects.hash(this.packageName, this.className, this.enclosingNames, this.primitive, this.array);
            }
        }
    }
}

