/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeInfoSupport;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Prototype.Blueprint(decorator=TypeInfoSupport.TypeInfoDecorator.class)
interface TypeInfoBlueprint
extends Annotated {
    @Option.Required
    public TypeName typeName();

    public TypeName rawType();

    public TypeName declaredType();

    @Option.Redundant
    public Optional<String> description();

    @Deprecated(forRemoval=true, since="4.1.0")
    @Option.Required
    @Option.Deprecated(value="kind")
    @Option.Redundant
    public String typeKind();

    @Option.Required
    public ElementKind kind();

    @Option.Singular
    public List<TypedElementInfo> elementInfo();

    @Option.Singular
    @Option.Redundant
    public List<TypedElementInfo> otherElementInfo();

    @Option.Singular
    @Option.Redundant
    public Map<TypeName, List<Annotation>> referencedTypeNamesToAnnotations();

    default public boolean hasMetaAnnotation(TypeName annotation, TypeName metaAnnotation) {
        return this.hasMetaAnnotation(annotation, metaAnnotation, false);
    }

    default public boolean hasMetaAnnotation(TypeName annotation, TypeName metaAnnotation, boolean inherited) {
        return this.metaAnnotation(annotation, metaAnnotation, inherited).isPresent();
    }

    default public Optional<Annotation> metaAnnotation(TypeName annotation, TypeName metaAnnotation) {
        return this.metaAnnotation(annotation, metaAnnotation, false);
    }

    default public Optional<Annotation> metaAnnotation(TypeName annotation, TypeName metaAnnotation, boolean inherited) {
        return this.metaAnnotation(annotation, metaAnnotation, inherited, new LinkedHashSet<TypeName>());
    }

    @Option.Singular
    @Option.Redundant
    public Map<TypeName, String> referencedModuleNames();

    public Optional<TypeInfo> superTypeInfo();

    @Option.Singular
    @Option.Redundant
    public List<TypeInfo> interfaceTypeInfo();

    @Deprecated(forRemoval=true, since="4.1.0")
    @Option.Singular
    @Option.Redundant
    @Option.Deprecated(value="elementModifiers")
    public Set<String> modifiers();

    @Option.Singular
    public Set<Modifier> elementModifiers();

    public AccessModifier accessModifier();

    public Optional<String> module();

    @Option.Redundant
    public Optional<Object> originatingElement();

    default public Object originatingElementValue() {
        return this.originatingElement().orElseGet(this::typeName);
    }

    default public Optional<TypeInfo> findInHierarchy(TypeName typeName) {
        TypeInfo superType;
        Optional<TypeInfo> foundInSuper;
        if (typeName.equals(this.typeName())) {
            return Optional.of((TypeInfo)this);
        }
        Optional<TypeInfo> superClass = this.superTypeInfo();
        if (superClass.isPresent() && !superClass.get().typeName().equals(TypeNames.OBJECT) && (foundInSuper = (superType = superClass.get()).findInHierarchy(typeName)).isPresent()) {
            return foundInSuper;
        }
        ArrayDeque<TypeInfo> interfaces = new ArrayDeque<TypeInfo>(this.interfaceTypeInfo());
        HashSet<TypeName> processed = new HashSet<TypeName>();
        while (!interfaces.isEmpty()) {
            TypeInfo type2 = (TypeInfo)interfaces.remove();
            if (!processed.add(type2.typeName())) continue;
            if (typeName.equals(type2.typeName())) {
                return Optional.of(type2);
            }
            interfaces.addAll(type2.interfaceTypeInfo());
        }
        return Optional.empty();
    }

    default public Optional<String> moduleNameOf(TypeName typeName) {
        String moduleName = this.referencedModuleNames().get(typeName);
        moduleName = moduleName != null && moduleName.isBlank() ? null : moduleName;
        return Optional.ofNullable(moduleName);
    }

    private Optional<Annotation> metaAnnotation(TypeName annotation, TypeName metaAnnotation, boolean inherited, Set<TypeName> processed) {
        List<Annotation> annotations = this.referencedTypeNamesToAnnotations().get(annotation);
        if (annotations == null) {
            return Optional.empty();
        }
        Optional<Annotation> found = Annotations.findFirst(metaAnnotation, annotations);
        if (found.isPresent()) {
            return found;
        }
        if (inherited) {
            for (Annotation referencedAnnotation : annotations) {
                if (!processed.add(referencedAnnotation.typeName()) || !(found = this.metaAnnotation(referencedAnnotation.typeName(), metaAnnotation, inherited, processed)).isPresent()) continue;
                return found;
            }
        }
        return Optional.empty();
    }
}

