/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfoBlueprint;
import io.helidon.common.types.TypeInfoSupport;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface TypeInfo
extends TypeInfoBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TypeInfo instance) {
        return (Builder)TypeInfo.builder().from(instance);
    }

    public static class Builder
    extends BuilderBase<Builder, TypeInfo>
    implements io.helidon.common.Builder<Builder, TypeInfo> {
        private Builder() {
        }

        @Override
        public TypeInfo buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.TypeInfoImpl(this);
        }

        @Override
        public TypeInfo build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends TypeInfo>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Annotation> annotations = new ArrayList<Annotation>();
        private final List<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
        private final List<TypeInfo> interfaceTypeInfo = new ArrayList<TypeInfo>();
        private final List<TypedElementInfo> elementInfo = new ArrayList<TypedElementInfo>();
        private final List<TypedElementInfo> otherElementInfo = new ArrayList<TypedElementInfo>();
        private final Map<TypeName, String> referencedModuleNames = new LinkedHashMap<TypeName, String>();
        private final Map<TypeName, List<Annotation>> referencedTypeNamesToAnnotations = new LinkedHashMap<TypeName, List<Annotation>>();
        private final Set<Modifier> elementModifiers = new LinkedHashSet<Modifier>();
        private final Set<String> modifiers = new LinkedHashSet<String>();
        private AccessModifier accessModifier;
        private boolean isAnnotationsMutated;
        private boolean isElementInfoMutated;
        private boolean isInheritedAnnotationsMutated;
        private boolean isInterfaceTypeInfoMutated;
        private boolean isOtherElementInfoMutated;
        private ElementKind kind;
        private Object originatingElement;
        private String description;
        private String module;
        private String typeKind;
        private TypeInfo superTypeInfo;
        private TypeName declaredType;
        private TypeName rawType;
        private TypeName typeName;

        protected BuilderBase() {
        }

        public BUILDER from(TypeInfo prototype) {
            this.typeName(prototype.typeName());
            this.rawType(prototype.rawType());
            this.declaredType(prototype.declaredType());
            this.description(prototype.description());
            this.typeKind(prototype.typeKind());
            this.kind(prototype.kind());
            if (!this.isElementInfoMutated) {
                this.elementInfo.clear();
            }
            this.addElementInfo(prototype.elementInfo());
            if (!this.isOtherElementInfoMutated) {
                this.otherElementInfo.clear();
            }
            this.addOtherElementInfo(prototype.otherElementInfo());
            this.addReferencedTypeNamesToAnnotations(prototype.referencedTypeNamesToAnnotations());
            this.addReferencedModuleNames(prototype.referencedModuleNames());
            this.superTypeInfo(prototype.superTypeInfo());
            if (!this.isInterfaceTypeInfoMutated) {
                this.interfaceTypeInfo.clear();
            }
            this.addInterfaceTypeInfo(prototype.interfaceTypeInfo());
            this.addModifiers(prototype.modifiers());
            this.addElementModifiers(prototype.elementModifiers());
            this.accessModifier(prototype.accessModifier());
            this.module(prototype.module());
            this.originatingElement(prototype.originatingElement());
            if (!this.isAnnotationsMutated) {
                this.annotations.clear();
            }
            this.addAnnotations(prototype.annotations());
            if (!this.isInheritedAnnotationsMutated) {
                this.inheritedAnnotations.clear();
            }
            this.addInheritedAnnotations(prototype.inheritedAnnotations());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.typeName().ifPresent(this::typeName);
            builder.rawType().ifPresent(this::rawType);
            builder.declaredType().ifPresent(this::declaredType);
            builder.description().ifPresent(this::description);
            builder.typeKind().ifPresent(this::typeKind);
            builder.kind().ifPresent(this::kind);
            if (this.isElementInfoMutated) {
                if (builder.isElementInfoMutated) {
                    this.addElementInfo(builder.elementInfo);
                }
            } else {
                this.elementInfo.clear();
                this.addElementInfo(builder.elementInfo);
            }
            if (this.isOtherElementInfoMutated) {
                if (builder.isOtherElementInfoMutated) {
                    this.addOtherElementInfo(builder.otherElementInfo);
                }
            } else {
                this.otherElementInfo.clear();
                this.addOtherElementInfo(builder.otherElementInfo);
            }
            this.addReferencedTypeNamesToAnnotations(builder.referencedTypeNamesToAnnotations);
            this.addReferencedModuleNames(builder.referencedModuleNames);
            builder.superTypeInfo().ifPresent(this::superTypeInfo);
            if (this.isInterfaceTypeInfoMutated) {
                if (builder.isInterfaceTypeInfoMutated) {
                    this.addInterfaceTypeInfo(builder.interfaceTypeInfo);
                }
            } else {
                this.interfaceTypeInfo.clear();
                this.addInterfaceTypeInfo(builder.interfaceTypeInfo);
            }
            this.addModifiers(builder.modifiers);
            this.addElementModifiers(builder.elementModifiers);
            builder.accessModifier().ifPresent(this::accessModifier);
            builder.module().ifPresent(this::module);
            builder.originatingElement().ifPresent(this::originatingElement);
            if (this.isAnnotationsMutated) {
                if (builder.isAnnotationsMutated) {
                    this.addAnnotations(builder.annotations);
                }
            } else {
                this.annotations.clear();
                this.addAnnotations(builder.annotations);
            }
            if (this.isInheritedAnnotationsMutated) {
                if (builder.isInheritedAnnotationsMutated) {
                    this.addInheritedAnnotations(builder.inheritedAnnotations);
                }
            } else {
                this.inheritedAnnotations.clear();
                this.addInheritedAnnotations(builder.inheritedAnnotations);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(TypeName typeName) {
            Objects.requireNonNull(typeName);
            this.typeName = typeName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.typeName(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER typeName(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.typeName(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rawType(TypeName rawType) {
            Objects.requireNonNull(rawType);
            this.rawType = rawType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rawType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.rawType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rawType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.rawType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaredType(TypeName declaredType) {
            Objects.requireNonNull(declaredType);
            this.declaredType = declaredType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaredType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.declaredType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaredType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.declaredType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDescription() {
            this.description = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.1.0", forRemoval=true)
        public BUILDER typeKind(String typeKind) {
            Objects.requireNonNull(typeKind);
            this.typeKind = typeKind;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER kind(ElementKind kind) {
            Objects.requireNonNull(kind);
            this.kind = kind;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementInfo(List<? extends TypedElementInfo> elementInfo) {
            Objects.requireNonNull(elementInfo);
            this.isElementInfoMutated = true;
            this.elementInfo.clear();
            this.elementInfo.addAll(elementInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementInfo(List<? extends TypedElementInfo> elementInfo) {
            Objects.requireNonNull(elementInfo);
            this.isElementInfoMutated = true;
            this.elementInfo.addAll(elementInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementInfo(TypedElementInfo elementInfo) {
            Objects.requireNonNull(elementInfo);
            this.elementInfo.add(elementInfo);
            this.isElementInfoMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementInfo(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.elementInfo.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER otherElementInfo(List<? extends TypedElementInfo> otherElementInfo) {
            Objects.requireNonNull(otherElementInfo);
            this.isOtherElementInfoMutated = true;
            this.otherElementInfo.clear();
            this.otherElementInfo.addAll(otherElementInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOtherElementInfo(List<? extends TypedElementInfo> otherElementInfo) {
            Objects.requireNonNull(otherElementInfo);
            this.isOtherElementInfoMutated = true;
            this.otherElementInfo.addAll(otherElementInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOtherElementInfo(TypedElementInfo otherElementInfo) {
            Objects.requireNonNull(otherElementInfo);
            this.otherElementInfo.add(otherElementInfo);
            this.isOtherElementInfoMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOtherElementInfo(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.otherElementInfo.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER referencedTypeNamesToAnnotations(Map<? extends TypeName, List<Annotation>> referencedTypeNamesToAnnotations) {
            Objects.requireNonNull(referencedTypeNamesToAnnotations);
            this.referencedTypeNamesToAnnotations.clear();
            this.referencedTypeNamesToAnnotations.putAll(referencedTypeNamesToAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addReferencedTypeNamesToAnnotations(Map<? extends TypeName, List<Annotation>> referencedTypeNamesToAnnotations) {
            Objects.requireNonNull(referencedTypeNamesToAnnotations);
            this.referencedTypeNamesToAnnotations.putAll(referencedTypeNamesToAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addReferencedTypeNamesToAnnotation(TypeName key, Annotation referencedTypeNamesToAnnotation) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(referencedTypeNamesToAnnotation);
            this.referencedTypeNamesToAnnotations.compute(key, (k, v) -> {
                v = v == null ? new ArrayList<Annotation>() : new ArrayList(v);
                v.add(referencedTypeNamesToAnnotation);
                return v;
            });
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addReferencedTypeNamesToAnnotations(TypeName key, List<Annotation> referencedTypeNamesToAnnotations) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(referencedTypeNamesToAnnotations);
            this.referencedTypeNamesToAnnotations.compute(key, (k, v) -> {
                v = v == null ? new ArrayList() : new ArrayList(v);
                v.addAll(referencedTypeNamesToAnnotations);
                return v;
            });
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putReferencedTypeNamesToAnnotation(TypeName key, List<Annotation> referencedTypeNamesToAnnotation) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(referencedTypeNamesToAnnotation);
            this.referencedTypeNamesToAnnotations.put(key, List.copyOf(referencedTypeNamesToAnnotation));
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER referencedModuleNames(Map<? extends TypeName, ? extends String> referencedModuleNames) {
            Objects.requireNonNull(referencedModuleNames);
            this.referencedModuleNames.clear();
            this.referencedModuleNames.putAll(referencedModuleNames);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addReferencedModuleNames(Map<? extends TypeName, ? extends String> referencedModuleNames) {
            Objects.requireNonNull(referencedModuleNames);
            this.referencedModuleNames.putAll(referencedModuleNames);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putReferencedModuleName(TypeName key, String referencedModuleName) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(referencedModuleName);
            this.referencedModuleNames.put(key, referencedModuleName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSuperTypeInfo() {
            this.superTypeInfo = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER superTypeInfo(TypeInfo superTypeInfo) {
            Objects.requireNonNull(superTypeInfo);
            this.superTypeInfo = superTypeInfo;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER superTypeInfo(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = TypeInfo.builder();
            consumer.accept(builder);
            this.superTypeInfo(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER interfaceTypeInfo(List<? extends TypeInfo> interfaceTypeInfo) {
            Objects.requireNonNull(interfaceTypeInfo);
            this.isInterfaceTypeInfoMutated = true;
            this.interfaceTypeInfo.clear();
            this.interfaceTypeInfo.addAll(interfaceTypeInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInterfaceTypeInfo(List<? extends TypeInfo> interfaceTypeInfo) {
            Objects.requireNonNull(interfaceTypeInfo);
            this.isInterfaceTypeInfoMutated = true;
            this.interfaceTypeInfo.addAll(interfaceTypeInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInterfaceTypeInfo(TypeInfo interfaceTypeInfo) {
            Objects.requireNonNull(interfaceTypeInfo);
            this.interfaceTypeInfo.add(interfaceTypeInfo);
            this.isInterfaceTypeInfoMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInterfaceTypeInfo(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = TypeInfo.builder();
            consumer.accept(builder);
            this.interfaceTypeInfo.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER modifiers(Set<? extends String> modifiers) {
            Objects.requireNonNull(modifiers);
            this.modifiers.clear();
            this.modifiers.addAll(modifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addModifiers(Set<? extends String> modifiers) {
            Objects.requireNonNull(modifiers);
            this.modifiers.addAll(modifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated(since="4.1.0", forRemoval=true)
        public BUILDER addModifier(String modifier) {
            Objects.requireNonNull(modifier);
            this.modifiers.add(modifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER elementModifiers(Set<? extends Modifier> elementModifiers) {
            Objects.requireNonNull(elementModifiers);
            this.elementModifiers.clear();
            this.elementModifiers.addAll(elementModifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementModifiers(Set<? extends Modifier> elementModifiers) {
            Objects.requireNonNull(elementModifiers);
            this.elementModifiers.addAll(elementModifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addElementModifier(Modifier elementModifier) {
            Objects.requireNonNull(elementModifier);
            this.elementModifiers.add(elementModifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER accessModifier(AccessModifier accessModifier) {
            Objects.requireNonNull(accessModifier);
            this.accessModifier = accessModifier;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearModule() {
            this.module = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER module(String module) {
            Objects.requireNonNull(module);
            this.module = module;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOriginatingElement() {
            this.originatingElement = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER originatingElement(Object originatingElement) {
            Objects.requireNonNull(originatingElement);
            this.originatingElement = originatingElement;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER annotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.clear();
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotations(List<? extends Annotation> annotations) {
            Objects.requireNonNull(annotations);
            this.isAnnotationsMutated = true;
            this.annotations.addAll(annotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Annotation annotation) {
            Objects.requireNonNull(annotation);
            this.annotations.add(annotation);
            this.isAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.annotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER inheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.clear();
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotations(List<? extends Annotation> inheritedAnnotations) {
            Objects.requireNonNull(inheritedAnnotations);
            this.isInheritedAnnotationsMutated = true;
            this.inheritedAnnotations.addAll(inheritedAnnotations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Annotation inheritedAnnotation) {
            Objects.requireNonNull(inheritedAnnotation);
            this.inheritedAnnotations.add(inheritedAnnotation);
            this.isInheritedAnnotationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addInheritedAnnotation(Consumer<Annotation.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Annotation.Builder builder = Annotation.builder();
            consumer.accept(builder);
            this.inheritedAnnotations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> typeName() {
            return Optional.ofNullable(this.typeName);
        }

        public Optional<TypeName> rawType() {
            return Optional.ofNullable(this.rawType);
        }

        public Optional<TypeName> declaredType() {
            return Optional.ofNullable(this.declaredType);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        @Deprecated(since="4.1.0", forRemoval=true)
        public Optional<String> typeKind() {
            return Optional.ofNullable(this.typeKind);
        }

        public Optional<ElementKind> kind() {
            return Optional.ofNullable(this.kind);
        }

        public List<TypedElementInfo> elementInfo() {
            return this.elementInfo;
        }

        public List<TypedElementInfo> otherElementInfo() {
            return this.otherElementInfo;
        }

        public Map<TypeName, List<Annotation>> referencedTypeNamesToAnnotations() {
            return this.referencedTypeNamesToAnnotations;
        }

        public Map<TypeName, String> referencedModuleNames() {
            return this.referencedModuleNames;
        }

        public Optional<TypeInfo> superTypeInfo() {
            return Optional.ofNullable(this.superTypeInfo);
        }

        public List<TypeInfo> interfaceTypeInfo() {
            return this.interfaceTypeInfo;
        }

        @Deprecated(since="4.1.0", forRemoval=true)
        public Set<String> modifiers() {
            return this.modifiers;
        }

        public Set<Modifier> elementModifiers() {
            return this.elementModifiers;
        }

        public Optional<AccessModifier> accessModifier() {
            return Optional.ofNullable(this.accessModifier);
        }

        public Optional<String> module() {
            return Optional.ofNullable(this.module);
        }

        public Optional<Object> originatingElement() {
            return Optional.ofNullable(this.originatingElement);
        }

        public List<Annotation> annotations() {
            return this.annotations;
        }

        public List<Annotation> inheritedAnnotations() {
            return this.inheritedAnnotations;
        }

        public String toString() {
            return "TypeInfoBuilder{typeName=" + String.valueOf(this.typeName) + ",rawType=" + String.valueOf(this.rawType) + ",declaredType=" + String.valueOf(this.declaredType) + ",kind=" + String.valueOf((Object)this.kind) + ",elementInfo=" + String.valueOf(this.elementInfo) + ",superTypeInfo=" + String.valueOf(this.superTypeInfo) + ",elementModifiers=" + String.valueOf(this.elementModifiers) + ",accessModifier=" + String.valueOf((Object)this.accessModifier) + ",module=" + this.module + ",annotations=" + String.valueOf(this.annotations) + ",inheritedAnnotations=" + String.valueOf(this.inheritedAnnotations) + "}";
        }

        protected void preBuildPrototype() {
            new TypeInfoSupport.TypeInfoDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.typeName == null) {
                collector.fatal(this.getClass(), "Property \"typeName\" is required, but not set");
            }
            if (this.rawType == null) {
                collector.fatal(this.getClass(), "Property \"rawType\" must not be null, but not set");
            }
            if (this.declaredType == null) {
                collector.fatal(this.getClass(), "Property \"declaredType\" must not be null, but not set");
            }
            if (this.typeKind == null) {
                collector.fatal(this.getClass(), "Property \"typeKind\" is required, but not set");
            }
            if (this.kind == null) {
                collector.fatal(this.getClass(), "Property \"kind\" is required, but not set");
            }
            if (this.accessModifier == null) {
                collector.fatal(this.getClass(), "Property \"accessModifier\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER description(Optional<String> description) {
            Objects.requireNonNull(description);
            this.description = description.map(String.class::cast).orElse(this.description);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER superTypeInfo(Optional<? extends TypeInfo> superTypeInfo) {
            Objects.requireNonNull(superTypeInfo);
            this.superTypeInfo = superTypeInfo.map(TypeInfo.class::cast).orElse(this.superTypeInfo);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER module(Optional<String> module) {
            Objects.requireNonNull(module);
            this.module = module.map(String.class::cast).orElse(this.module);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER originatingElement(Optional<?> originatingElement) {
            Objects.requireNonNull(originatingElement);
            this.originatingElement = originatingElement.map(Object.class::cast).orElse(this.originatingElement);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class TypeInfoImpl
        implements TypeInfo {
            private final AccessModifier accessModifier;
            private final ElementKind kind;
            private final List<Annotation> annotations;
            private final List<Annotation> inheritedAnnotations;
            private final List<TypeInfo> interfaceTypeInfo;
            private final List<TypedElementInfo> elementInfo;
            private final List<TypedElementInfo> otherElementInfo;
            private final Map<TypeName, String> referencedModuleNames;
            private final Map<TypeName, List<Annotation>> referencedTypeNamesToAnnotations;
            private final Optional<TypeInfo> superTypeInfo;
            private final Optional<Object> originatingElement;
            private final Optional<String> description;
            private final Optional<String> module;
            private final Set<Modifier> elementModifiers;
            private final Set<String> modifiers;
            private final String typeKind;
            private final TypeName declaredType;
            private final TypeName rawType;
            private final TypeName typeName;

            protected TypeInfoImpl(BuilderBase<?, ?> builder) {
                this.typeName = builder.typeName().get();
                this.rawType = builder.rawType().get();
                this.declaredType = builder.declaredType().get();
                this.description = builder.description();
                this.typeKind = builder.typeKind().get();
                this.kind = builder.kind().get();
                this.elementInfo = List.copyOf(builder.elementInfo());
                this.otherElementInfo = List.copyOf(builder.otherElementInfo());
                this.referencedTypeNamesToAnnotations = Collections.unmodifiableMap(new LinkedHashMap<TypeName, List<Annotation>>(builder.referencedTypeNamesToAnnotations()));
                this.referencedModuleNames = Collections.unmodifiableMap(new LinkedHashMap<TypeName, String>(builder.referencedModuleNames()));
                this.superTypeInfo = builder.superTypeInfo();
                this.interfaceTypeInfo = List.copyOf(builder.interfaceTypeInfo());
                this.modifiers = Collections.unmodifiableSet(new LinkedHashSet<String>(builder.modifiers()));
                this.elementModifiers = Collections.unmodifiableSet(new LinkedHashSet<Modifier>(builder.elementModifiers()));
                this.accessModifier = builder.accessModifier().get();
                this.module = builder.module();
                this.originatingElement = builder.originatingElement();
                this.annotations = List.copyOf(builder.annotations());
                this.inheritedAnnotations = List.copyOf(builder.inheritedAnnotations());
            }

            @Override
            public TypeName typeName() {
                return this.typeName;
            }

            @Override
            public TypeName rawType() {
                return this.rawType;
            }

            @Override
            public TypeName declaredType() {
                return this.declaredType;
            }

            @Override
            public Optional<String> description() {
                return this.description;
            }

            @Override
            public String typeKind() {
                return this.typeKind;
            }

            @Override
            public ElementKind kind() {
                return this.kind;
            }

            @Override
            public List<TypedElementInfo> elementInfo() {
                return this.elementInfo;
            }

            @Override
            public List<TypedElementInfo> otherElementInfo() {
                return this.otherElementInfo;
            }

            @Override
            public Map<TypeName, List<Annotation>> referencedTypeNamesToAnnotations() {
                return this.referencedTypeNamesToAnnotations;
            }

            @Override
            public Map<TypeName, String> referencedModuleNames() {
                return this.referencedModuleNames;
            }

            @Override
            public Optional<TypeInfo> superTypeInfo() {
                return this.superTypeInfo;
            }

            @Override
            public List<TypeInfo> interfaceTypeInfo() {
                return this.interfaceTypeInfo;
            }

            @Override
            public Set<String> modifiers() {
                return this.modifiers;
            }

            @Override
            public Set<Modifier> elementModifiers() {
                return this.elementModifiers;
            }

            @Override
            public AccessModifier accessModifier() {
                return this.accessModifier;
            }

            @Override
            public Optional<String> module() {
                return this.module;
            }

            @Override
            public Optional<Object> originatingElement() {
                return this.originatingElement;
            }

            @Override
            public List<Annotation> annotations() {
                return this.annotations;
            }

            @Override
            public List<Annotation> inheritedAnnotations() {
                return this.inheritedAnnotations;
            }

            public String toString() {
                return "TypeInfo{typeName=" + String.valueOf(this.typeName) + ",rawType=" + String.valueOf(this.rawType) + ",declaredType=" + String.valueOf(this.declaredType) + ",kind=" + String.valueOf((Object)this.kind) + ",elementInfo=" + String.valueOf(this.elementInfo) + ",superTypeInfo=" + String.valueOf(this.superTypeInfo) + ",elementModifiers=" + String.valueOf(this.elementModifiers) + ",accessModifier=" + String.valueOf((Object)this.accessModifier) + ",module=" + String.valueOf(this.module) + ",annotations=" + String.valueOf(this.annotations) + ",inheritedAnnotations=" + String.valueOf(this.inheritedAnnotations) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TypeInfo)) {
                    return false;
                }
                TypeInfo other = (TypeInfo)o;
                return Objects.equals(this.typeName, other.typeName()) && Objects.equals(this.rawType, other.rawType()) && Objects.equals(this.declaredType, other.declaredType()) && Objects.equals((Object)this.kind, (Object)other.kind()) && Objects.equals(this.elementInfo, other.elementInfo()) && Objects.equals(this.superTypeInfo, other.superTypeInfo()) && Objects.equals(this.elementModifiers, other.elementModifiers()) && Objects.equals((Object)this.accessModifier, (Object)other.accessModifier()) && Objects.equals(this.module, other.module()) && Objects.equals(this.annotations, other.annotations()) && Objects.equals(this.inheritedAnnotations, other.inheritedAnnotations());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.typeName, this.rawType, this.declaredType, this.kind, this.elementInfo, this.superTypeInfo, this.elementModifiers, this.accessModifier, this.module, this.annotations, this.inheritedAnnotations});
            }
        }
    }
}

