/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.EnumValue;
import io.helidon.common.types.TypeName;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class AnnotationSupport {
    private AnnotationSupport() {
    }

    @Prototype.FactoryMethod
    public static Annotation create(TypeName annoTypeName, String value) {
        return ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(annoTypeName)).value(value)).build();
    }

    @Prototype.FactoryMethod
    public static Annotation create(TypeName annoTypeName, Map<String, ?> values) {
        return ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(annoTypeName)).values(values)).build();
    }

    @Prototype.FactoryMethod
    static Annotation create(Class<? extends java.lang.annotation.Annotation> annoType) {
        return ((Annotation.Builder)Annotation.builder().typeName(TypeName.create(annoType))).build();
    }

    @Prototype.FactoryMethod
    static Annotation create(TypeName annoType) {
        return ((Annotation.Builder)Annotation.builder().typeName(annoType)).build();
    }

    @Prototype.FactoryMethod
    static Annotation create(Class<? extends java.lang.annotation.Annotation> annoType, String value) {
        return AnnotationSupport.create(TypeName.create(annoType), value);
    }

    @Prototype.FactoryMethod
    static Annotation create(Class<? extends java.lang.annotation.Annotation> annoType, Map<String, ?> values) {
        return AnnotationSupport.create(TypeName.create(annoType), values);
    }

    @Prototype.PrototypeMethod
    @Prototype.Annotated(value={"java.lang.Override"})
    static int compareTo(Annotation me, Annotation o) {
        return me.typeName().compareTo(o.typeName());
    }

    @Prototype.BuilderMethod
    static void type(Annotation.BuilderBase<?, ?> builder, Type annoType) {
        builder.typeName(TypeName.create(annoType));
    }

    @Prototype.BuilderMethod
    static void value(Annotation.BuilderBase<?, ?> builder, String value) {
        builder.putValue("value", value);
    }

    static Optional<String> asString(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asString(typeName, property, value));
    }

    static Optional<List<String>> asStrings(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<String> result = new ArrayList<String>();
            for (Object o : list) {
                result.add(AnnotationSupport.asString(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(AnnotationSupport.asString(typeName, property, value)));
    }

    static Optional<Integer> asInt(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asInt(typeName, property, value));
    }

    static Optional<List<Integer>> asInts(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (Object o : list) {
                result.add(AnnotationSupport.asInt(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(Integer.valueOf(AnnotationSupport.asInt(typeName, property, value))));
    }

    static Optional<Long> asLong(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asLong(typeName, property, value));
    }

    static Optional<List<Long>> asLongs(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Long> result = new ArrayList<Long>();
            for (Object o : list) {
                result.add(AnnotationSupport.asLong(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(Long.valueOf(AnnotationSupport.asLong(typeName, property, value))));
    }

    static Optional<Boolean> asBoolean(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asBoolean(typeName, property, value));
    }

    static Optional<List<Boolean>> asBooleans(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Boolean> result = new ArrayList<Boolean>();
            for (Object o : list) {
                result.add(AnnotationSupport.asBoolean(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(Boolean.valueOf(AnnotationSupport.asBoolean(typeName, property, value))));
    }

    static Optional<Byte> asByte(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asByte(typeName, property, value));
    }

    static Optional<List<Byte>> asBytes(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Byte> result = new ArrayList<Byte>();
            for (Object o : list) {
                result.add(AnnotationSupport.asByte(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(Byte.valueOf(AnnotationSupport.asByte(typeName, property, value))));
    }

    static Optional<Character> asCharacter(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(AnnotationSupport.asCharacter(typeName, property, value)));
    }

    static Optional<List<Character>> asCharacters(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Character> result = new ArrayList<Character>();
            for (Object o : list) {
                result.add(Character.valueOf(AnnotationSupport.asCharacter(typeName, property, o)));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(Character.valueOf(AnnotationSupport.asCharacter(typeName, property, value))));
    }

    static Optional<Short> asShort(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asShort(typeName, property, value));
    }

    static Optional<List<Short>> asShorts(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Short> result = new ArrayList<Short>();
            for (Object o : list) {
                result.add(AnnotationSupport.asShort(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(Short.valueOf(AnnotationSupport.asShort(typeName, property, value))));
    }

    static Optional<Float> asFloat(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(AnnotationSupport.asFloat(typeName, property, value)));
    }

    static Optional<List<Float>> asFloats(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Float> result = new ArrayList<Float>();
            for (Object o : list) {
                result.add(Float.valueOf(AnnotationSupport.asFloat(typeName, property, o)));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(Float.valueOf(AnnotationSupport.asFloat(typeName, property, value))));
    }

    static Optional<Double> asDouble(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asDouble(typeName, property, value));
    }

    static Optional<List<Double>> asDoubles(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Double> result = new ArrayList<Double>();
            for (Object o : list) {
                result.add(AnnotationSupport.asDouble(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(Double.valueOf(AnnotationSupport.asDouble(typeName, property, value))));
    }

    static Optional<Class<?>> asClass(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asClass(typeName, property, value));
    }

    static Optional<List<Class<?>>> asClasses(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList result = new ArrayList();
            for (Object o : list) {
                result.add(AnnotationSupport.asClass(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(AnnotationSupport.asClass(typeName, property, value)));
    }

    static Optional<TypeName> asTypeName(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asTypeName(typeName, property, value));
    }

    static Optional<List<TypeName>> asTypeNames(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<TypeName> result = new ArrayList<TypeName>();
            for (Object o : list) {
                result.add(AnnotationSupport.asTypeName(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(AnnotationSupport.asTypeName(typeName, property, value)));
    }

    static Optional<Annotation> asAnnotation(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asAnnotation(typeName, property, value));
    }

    static Optional<List<Annotation>> asAnnotations(TypeName typeName, Map<String, Object> values, String property) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            for (Object o : list) {
                result.add(AnnotationSupport.asAnnotation(typeName, property, o));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(AnnotationSupport.asAnnotation(typeName, property, value)));
    }

    static <T extends Enum<T>> Optional<T> asEnum(TypeName typeName, Map<String, Object> values, String property, Class<T> type2) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(AnnotationSupport.asEnum(typeName, property, value, type2));
    }

    static <T extends Enum<T>> Optional<List<T>> asEnums(TypeName typeName, Map<String, Object> values, String property, Class<T> type2) {
        Object value = values.get(property);
        if (value == null) {
            return Optional.empty();
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<T> result = new ArrayList<T>();
            for (Object o : list) {
                result.add(AnnotationSupport.asEnum(typeName, property, o, type2));
            }
            return Optional.of(List.copyOf(result));
        }
        return Optional.of(List.of(AnnotationSupport.asEnum(typeName, property, value, type2)));
    }

    private static int asInt(TypeName typeName, String property, Object value) {
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Integer.parseInt(str);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Integer");
    }

    private static long asLong(TypeName typeName, String property, Object value) {
        if (value instanceof Long) {
            Long number = (Long)value;
            return number;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Long.parseLong(str);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Long");
    }

    private static boolean asBoolean(TypeName typeName, String property, Object value) {
        if (value instanceof Boolean) {
            Boolean number = (Boolean)value;
            return number;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Boolean.parseBoolean(str);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Boolean");
    }

    private static String asString(TypeName typeName, String property, Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return str;
        }
        if (value instanceof TypeName) {
            TypeName tn = (TypeName)value;
            return tn.fqName();
        }
        if (value instanceof EnumValue) {
            EnumValue ev = (EnumValue)value;
            return ev.name();
        }
        if (value instanceof List) {
            throw new IllegalArgumentException(typeName.fqName() + " property " + property + " is a list, cannot be converted to String");
        }
        if (value instanceof Annotation) {
            throw new IllegalArgumentException(typeName.fqName() + " property " + property + " is a nested annotation, cannot be converted to String");
        }
        return String.valueOf(value);
    }

    private static byte asByte(TypeName typeName, String property, Object value) {
        if (value instanceof Byte) {
            Byte number = (Byte)value;
            return number;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Byte.parseByte(str);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Byte");
    }

    private static char asCharacter(TypeName typeName, String property, Object value) {
        if (value instanceof Character) {
            Character number = (Character)value;
            return number.charValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            if (str.length() != 1) {
                throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type String and value \"" + str + "\" cannot be converted to Character");
            }
            return str.charAt(0);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Character");
    }

    private static short asShort(TypeName typeName, String property, Object value) {
        if (value instanceof Short) {
            Short number = (Short)value;
            return number;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Short.parseShort(str);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Short");
    }

    private static float asFloat(TypeName typeName, String property, Object value) {
        if (value instanceof Float) {
            Float number = (Float)value;
            return number.floatValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            return Float.parseFloat(str);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Float");
    }

    private static double asDouble(TypeName typeName, String property, Object value) {
        if (value instanceof Double) {
            Double number = (Double)value;
            return number;
        }
        if (value instanceof String) {
            String str = (String)value;
            return Double.parseDouble(str);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Double");
    }

    private static Class<?> asClass(TypeName typeName, String property, Object value) {
        if (value instanceof Class) {
            Class theClass = (Class)value;
            return theClass;
        }
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        String className = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeName.class, String.class}, (Object)object2, n)) {
            case 0 -> {
                TypeName tn = (TypeName)object2;
                yield tn.name();
            }
            case 1 -> {
                String str;
                yield str = (String)object2;
            }
            default -> throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Class");
        };
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type String and value \"" + className + "\" cannot be converted to Class");
        }
    }

    private static TypeName asTypeName(TypeName typeName, String property, Object value) {
        if (value instanceof TypeName) {
            TypeName tn = (TypeName)value;
            return tn;
        }
        if (value instanceof Class) {
            Class theClass = (Class)value;
            return TypeName.create(theClass);
        }
        if (value instanceof String) {
            String str = (String)value;
            return TypeName.create(str);
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to TypeName");
    }

    private static Annotation asAnnotation(TypeName typeName, String property, Object value) {
        if (value instanceof Annotation) {
            Annotation annotation = (Annotation)value;
            return annotation;
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Annotation");
    }

    private static <T extends Enum<T>> T asEnum(TypeName typeName, String property, Object value, Class<T> type2) {
        if (type2.isInstance(value)) {
            return (T)((Enum)type2.cast(value));
        }
        if (value instanceof String) {
            String str = (String)value;
            return Enum.valueOf(type2, str);
        }
        if (value instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)value;
            if (enumValue.type().equals(TypeName.create(type2))) {
                return Enum.valueOf(type2, enumValue.name());
            }
            throw new IllegalStateException("Property " + property + " is of enum type for enum " + enumValue.type().fqName() + ", yet you requested " + type2.getName());
        }
        throw new IllegalArgumentException(typeName.fqName() + " property " + property + " of type " + value.getClass().getName() + " cannot be converted to Enum of type " + type2.getName());
    }
}

