/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.MediaType;
import java.util.HashMap;
import java.util.Map;

enum MediaTypeEnum implements MediaType
{
    WILDCARD("*", "*", true),
    APPLICATION_XML("application", "xml"),
    APPLICATION_ATOM_XML("application", "atom+xml"),
    APPLICATION_XHTML_XML("application", "xhtml+xml"),
    APPLICATION_SVG_XML("application", "svg+xml"),
    APPLICATION_JSON("application", "json"),
    APPLICATION_JSON_PATCH_JSON("application", "json-patch+json"),
    APPLICATION_STREAM_JSON("application", "stream+json"),
    APPLICATION_FORM_URLENCODED("application", "x-www-form-urlencoded"),
    MULTIPART_FORM_DATA("multipart", "form-data"),
    MULTIPART_BYTERANGES("multipart", "byteranges"),
    APPLICATION_OCTET_STREAM("application", "octet-stream"),
    TEXT_PLAIN("text", "plain"),
    TEXT_XML("text", "xml"),
    TEXT_HTML("text", "html"),
    APPLICATION_OPENMETRICS_TEXT("application", "openmetrics-text"),
    APPLICATION_OPENAPI_YAML("application", "vnd.oai.openapi"),
    APPLICATION_OPENAPI_JSON("application", "vnd.oai.openapi+json"),
    APPLICATION_X_YAML("application", "x-yaml"),
    APPLICATION_YAML("application", "yaml"),
    TEXT_X_YAML("text", "x-yaml"),
    TEXT_YAML("text", "yaml"),
    APPLICATION_JAVASCRIPT("application", "javascript"),
    TEXT_EVENT_STREAM("text", "event-stream"),
    APPLICATION_X_NDJSON("application", "x-ndjson"),
    APPLICATION_HOCON("application", "hocon");

    private static final Map<String, MediaTypeEnum> BY_FULL_TYPE;
    private final String type;
    private final String subtype;
    private final String fullType;
    private final boolean wildcard;

    private MediaTypeEnum(String type2, String subtype) {
        this(type2, subtype, false);
    }

    private MediaTypeEnum(String type2, String subtype, boolean wildcard) {
        this.type = type2;
        this.subtype = subtype;
        this.fullType = type2 + "/" + subtype;
        this.wildcard = wildcard;
    }

    static MediaTypeEnum find(String fullType) {
        return BY_FULL_TYPE.get(fullType);
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String subtype() {
        return this.subtype;
    }

    @Override
    public String text() {
        return this.fullType;
    }

    @Override
    public boolean isWildcardType() {
        return this.wildcard;
    }

    @Override
    public boolean isWildcardSubtype() {
        return this.wildcard;
    }

    static {
        HashMap<String, MediaTypeEnum> byFullType = new HashMap<String, MediaTypeEnum>();
        for (MediaTypeEnum value : MediaTypeEnum.values()) {
            byFullType.put(value.text(), value);
        }
        BY_FULL_TYPE = Map.copyOf(byFullType);
    }
}

