/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.mapper.OptionalValue;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

class ValueEmpty<T>
implements OptionalValue<T> {
    private final Mappers mapperManager;
    private final GenericType<T> type;
    private final String name;
    private final String[] qualifiers;

    ValueEmpty(Mappers mapperManager, GenericType<T> type2, String name, String[] qualifiers) {
        this.mapperManager = mapperManager;
        this.type = type2;
        this.name = name;
        this.qualifiers = qualifiers;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Optional<T> asOptional() throws MapperException {
        return Optional.empty();
    }

    @Override
    public <N> OptionalValue<N> as(Function<? super T, ? extends N> mapper) {
        return this;
    }

    @Override
    public <N> OptionalValue<N> as(Class<N> type2) throws MapperException {
        GenericType<Class<N>> wantedType = GenericType.create(type2);
        if (this.mapperManager.mapper(this.type, wantedType, this.qualifiers).isPresent()) {
            return new ValueEmpty<Class<N>>(this.mapperManager, wantedType, this.name, this.qualifiers);
        }
        throw new MapperException(this.type, wantedType, "Cannot find mapper for " + this.name());
    }

    @Override
    public <N> OptionalValue<N> as(GenericType<N> type2) throws MapperException {
        if (this.mapperManager.mapper(this.type, type2, this.qualifiers).isPresent()) {
            return new ValueEmpty<N>(this.mapperManager, type2, this.name, this.qualifiers);
        }
        throw new MapperException(this.type, type2, "Cannot find mapper for " + this.name());
    }

    @Override
    public T get() {
        throw new NoSuchElementException("No value present for " + this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OptionalValue)) {
            return false;
        }
        OptionalValue other = (OptionalValue)o;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.asOptional(), other.asOptional());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

