/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.mapper.Value;
import io.helidon.common.mapper.ValueBacked;
import io.helidon.common.mapper.ValueEmpty;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface OptionalValue<T>
extends Value<T> {
    public static <T> OptionalValue<T> create(Mappers mapperManager, String name, Class<T> type2, String ... qualifiers) {
        Objects.requireNonNull(name, "Name of the Value must not be null");
        return OptionalValue.create(mapperManager, name, GenericType.create(type2), qualifiers);
    }

    public static <T> OptionalValue<T> create(Mappers mapperManager, String name, GenericType<T> type2, String ... qualifiers) {
        Objects.requireNonNull(name, "Name of the Value must not be null");
        return new ValueEmpty<T>(mapperManager, type2, name, qualifiers);
    }

    public static <T> OptionalValue<T> create(Mappers mapperManager, String name, T value, String ... qualifiers) {
        Objects.requireNonNull(name, "Name of the Value must not be null");
        Objects.requireNonNull(value, "Value content for Value " + name + " must not be null, use empty(String) instead");
        return new ValueBacked<T>(mapperManager, name, value, qualifiers);
    }

    public static <T> OptionalValue<T> create(Mappers mapperManager, String name, T value, GenericType<T> type2, String ... qualifiers) {
        Objects.requireNonNull(name, "Name of the Value must not be null");
        Objects.requireNonNull(value, "Value content for Value " + name + " must not be null, use empty(String) instead");
        return new ValueBacked<T>(mapperManager, name, value, type2, qualifiers);
    }

    @Override
    public <N> OptionalValue<N> as(Class<N> var1);

    @Override
    public <N> OptionalValue<N> as(GenericType<N> var1);

    @Override
    public <N> OptionalValue<N> as(Function<? super T, ? extends N> var1);

    @Override
    public T get();

    default public Optional<T> or(Supplier<? extends Optional<T>> supplier) {
        return this.asOptional().or(supplier);
    }

    default public boolean isPresent() {
        return this.asOptional().isPresent();
    }

    default public boolean isEmpty() {
        return this.asOptional().isEmpty();
    }

    default public void ifPresentOrElse(Consumer<T> action, Runnable emptyAction) {
        this.asOptional().ifPresentOrElse(action, emptyAction);
    }

    default public void ifPresent(Consumer<? super T> consumer) {
        this.asOptional().ifPresent(consumer);
    }

    default public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.asOptional().map(mapper);
    }

    default public T orElse(T other) {
        return this.asOptional().orElse(other);
    }

    default public T orElseGet(Supplier<? extends T> other) {
        return this.asOptional().orElseGet(other);
    }

    default public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.asOptional().orElseThrow(exceptionSupplier);
    }

    default public T orElseThrow() {
        return this.orElseThrow(() -> new NoSuchElementException("No value present for " + this.name()));
    }

    default public OptionalValue<Boolean> asBoolean() {
        return this.as(Boolean.class);
    }

    default public OptionalValue<String> asString() {
        return this.as(String.class);
    }

    default public OptionalValue<Integer> asInt() {
        return this.as(Integer.class);
    }

    default public OptionalValue<Long> asLong() {
        return this.as(Long.class);
    }

    default public OptionalValue<Double> asDouble() {
        return this.as(Double.class);
    }
}

