/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.builder.api.Prototype;
import io.helidon.common.GenericType;
import io.helidon.common.Weighted;
import io.helidon.common.Weights;
import io.helidon.common.mapper.BuiltInMappers;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.mapper.MappersConfig;
import io.helidon.common.mapper.spi.MapperProvider;
import java.util.List;
import java.util.Set;

final class MappersConfigSupport {
    private MappersConfigSupport() {
    }

    static class BuilderDecorator
    implements Prototype.BuilderDecorator<MappersConfig.BuilderBase<?, ?>> {
        BuilderDecorator() {
        }

        @Override
        public void decorate(MappersConfig.BuilderBase<?, ?> target) {
            if (target.useBuiltInMappers()) {
                target.addMapperProvider(new BuiltInMappers());
            }
            List<Mapper<?, ?>> mappers = target.mappers();
            for (Mapper<?, ?> mapper : mappers) {
                target.addMapperProvider(new GenericMapperProvider(mapper, mapper.sourceType(), mapper.targetType(), Weights.find(mapper, 100.0), mapper.qualifiers()));
            }
        }
    }

    private static final class ClassMapperProvider
    implements MapperProvider,
    Weighted {
        private final Mapper<Object, Object> mapper;
        private final Class<Object> sourceType;
        private final Class<Object> targetType;
        private final double weight;
        private final Set<String> qualifiers;

        private ClassMapperProvider(Mapper mapper, Class sourceType, Class targetType, double weight, Set<String> qualifiers) {
            this.mapper = mapper;
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.weight = weight;
            this.qualifiers = qualifiers;
        }

        @Override
        public MapperProvider.ProviderResponse mapper(Class<?> sourceClass, Class<?> targetClass, String qualifier) {
            if (this.sourceType == sourceClass && this.targetType == targetClass) {
                if (this.qualifiers.contains(qualifier)) {
                    return new MapperProvider.ProviderResponse(MapperProvider.Support.SUPPORTED, this.mapper);
                }
                return new MapperProvider.ProviderResponse(MapperProvider.Support.COMPATIBLE, this.mapper);
            }
            return MapperProvider.ProviderResponse.unsupported();
        }

        @Override
        public double weight() {
            return this.weight;
        }
    }

    private static final class GenericMapperProvider
    implements MapperProvider,
    Weighted {
        private final Mapper mapper;
        private final GenericType sourceType;
        private final GenericType targetType;
        private final double weight;
        private final Set<String> qualifiers;

        private GenericMapperProvider(Mapper mapper, GenericType sourceType, GenericType targetType, double weight, Set<String> qualifiers) {
            this.mapper = mapper;
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.weight = weight;
            this.qualifiers = qualifiers;
        }

        @Override
        public MapperProvider.ProviderResponse mapper(Class<?> sourceClass, Class<?> targetClass, String qualifier) {
            return MapperProvider.ProviderResponse.unsupported();
        }

        @Override
        public MapperProvider.ProviderResponse mapper(GenericType<?> sourceType, GenericType<?> targetType, String qualifier) {
            if (sourceType.equals(this.sourceType) && targetType.equals(this.targetType)) {
                if (this.qualifiers.contains(qualifier)) {
                    return new MapperProvider.ProviderResponse(MapperProvider.Support.SUPPORTED, this.mapper);
                }
                return new MapperProvider.ProviderResponse(MapperProvider.Support.COMPATIBLE, this.mapper);
            }
            return MapperProvider.ProviderResponse.unsupported();
        }

        @Override
        public double weight() {
            return this.weight;
        }
    }

    static final class CustomMethods {
        private CustomMethods() {
        }

        @Prototype.BuilderMethod
        static <S, T> void addMapper(MappersConfig.BuilderBase<?, ?> builder, Mapper<S, T> mapper, Class<S> sourceType, Class<T> targetType, String ... qualifiers) {
            CustomMethods.addMapper(builder, mapper, sourceType, targetType, 100.0, qualifiers);
        }

        @Prototype.BuilderMethod
        static <S, T> void addMapper(MappersConfig.BuilderBase<?, ?> builder, Mapper<S, T> mapper, GenericType<S> sourceType, GenericType<T> targetType, String ... qualifiers) {
            CustomMethods.addMapper(builder, mapper, sourceType, targetType, 100.0, qualifiers);
        }

        @Prototype.BuilderMethod
        static <S, T> void addMapper(MappersConfig.BuilderBase<?, ?> builder, Mapper<S, T> mapper, Class<S> sourceType, Class<T> targetType, double weight, String ... qualifiers) {
            builder.addMapperProvider(new ClassMapperProvider(mapper, sourceType, targetType, weight, Set.of(qualifiers)));
        }

        @Prototype.BuilderMethod
        static <S, T> void addMapper(MappersConfig.BuilderBase<?, ?> builder, Mapper<S, T> mapper, GenericType<S> sourceType, GenericType<T> targetType, double weight, String ... qualifiers) {
            if (sourceType.isClass() && targetType.isClass()) {
                builder.addMapperProvider(new ClassMapperProvider(mapper, sourceType.rawType(), targetType.rawType(), weight, Set.of(qualifiers)));
            } else {
                builder.addMapperProvider(new GenericMapperProvider(mapper, sourceType, targetType, weight, Set.of(qualifiers)));
            }
        }
    }
}

