/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.context;

import io.helidon.common.context.Contexts;
import io.helidon.common.context.ListContext;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public interface Context {
    public static Context create() {
        return Context.builder().build();
    }

    public static Context create(Context parent) {
        return Context.builder().parent(parent).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> void register(T var1);

    public <T> void supply(Class<T> var1, Supplier<T> var2);

    public <T> Optional<T> get(Class<T> var1);

    public <T> void register(Object var1, T var2);

    public <T> void supply(Object var1, Class<T> var2, Supplier<T> var3);

    public <T> Optional<T> get(Object var1, Class<T> var2);

    public String id();

    public static class Builder
    implements io.helidon.common.Builder<Builder, Context> {
        private static final AtomicLong PARENT_CONTEXT_COUNTER = new AtomicLong(1L);
        private static final AtomicLong CHILD_CONTEXT_COUNTER = new AtomicLong(1L);
        private Context parent;
        private String id;
        private boolean notGlobal = true;

        @Deprecated(forRemoval=true, since="4.0.9")
        public Builder() {
        }

        @Override
        public Context build() {
            if (this.id == null) {
                this.id = this.generateId();
            }
            if (this.notGlobal && this.parent == null) {
                this.parent = Contexts.globalContext();
            }
            return new ListContext(this);
        }

        Builder global() {
            this.notGlobal = false;
            return this;
        }

        private String generateId() {
            if (null == this.parent) {
                return String.valueOf(PARENT_CONTEXT_COUNTER.getAndIncrement());
            }
            if (this.parent instanceof ListContext) {
                return this.parent.id() + ":" + ((ListContext)this.parent).nextChildId();
            }
            long nextId = CHILD_CONTEXT_COUNTER.getAndUpdate(operand -> operand == Long.MAX_VALUE ? 1L : operand + 1L);
            return this.parent.id() + ":" + nextId;
        }

        public Builder parent(Context parent) {
            this.parent = parent;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        Context parent() {
            return this.parent;
        }

        String id() {
            return this.id;
        }
    }
}

