/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.common.configurable.ObserverManager;
import io.helidon.common.configurable.ThreadPool;
import io.helidon.common.configurable.ThreadPoolConfig;
import io.helidon.common.context.Contexts;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=ThreadPoolConfig.class)
public final class ThreadPoolSupplier
implements Supplier<ExecutorService>,
RuntimeType.Api<ThreadPoolConfig> {
    static final ThreadPool.RejectionHandler DEFAULT_REJECTION_POLICY = new ThreadPool.RejectionHandler();
    private static final System.Logger LOGGER = System.getLogger(ThreadPoolSupplier.class.getName());
    private static final AtomicInteger DEFAULT_NAME_COUNTER = new AtomicInteger();
    private final int corePoolSize;
    private final int maxPoolSize;
    private final int keepAliveMinutes;
    private final int queueCapacity;
    private final boolean isDaemon;
    private final String threadNamePrefix;
    private final boolean prestart;
    private final String name;
    private final int growthThreshold;
    private final int growthRate;
    private final ThreadPool.RejectionHandler rejectionHandler;
    private final LazyValue<ExecutorService> lazyValue = LazyValue.create(() -> Contexts.wrap(this.getThreadPool()));
    private final boolean useVirtualThreads;
    private final ThreadPoolConfig config;

    private ThreadPoolSupplier(ThreadPoolConfig config) {
        this.config = config;
        this.corePoolSize = config.corePoolSize();
        this.maxPoolSize = config.maxPoolSize();
        this.keepAliveMinutes = config.keepAlive().toMinutesPart();
        this.queueCapacity = config.queueCapacity();
        this.isDaemon = config.daemon();
        this.prestart = config.shouldPrestart();
        this.growthThreshold = config.growthThreshold();
        this.growthRate = config.growthRate();
        this.rejectionHandler = config.rejectionHandler();
        this.useVirtualThreads = config.virtualThreads();
        Object poolName = config.name().orElse(null);
        Object threadNamePrefix = config.threadNamePrefix().orElse(null);
        if (poolName == null) {
            if (config.threadNamePrefix().isEmpty()) {
                threadNamePrefix = "helidon-";
                LOGGER.log(System.Logger.Level.WARNING, "Neither a thread name prefix nor a pool name specified");
            }
            poolName = (String)threadNamePrefix + "thread-pool-" + DEFAULT_NAME_COUNTER.incrementAndGet();
        } else if (threadNamePrefix == null) {
            threadNamePrefix = "helidon-" + (String)poolName + "-";
        }
        this.name = poolName;
        this.threadNamePrefix = threadNamePrefix;
        ObserverManager.registerSupplier(this, this.name, "general");
    }

    public static ThreadPoolConfig.Builder builder() {
        return ThreadPoolConfig.builder();
    }

    public static ThreadPoolSupplier create(Config config, String name) {
        return ((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)ThreadPoolSupplier.builder().name(name)).config(config)).build();
    }

    public static ThreadPoolSupplier create(String name) {
        return ((ThreadPoolConfig.Builder)ThreadPoolSupplier.builder().name(name)).build();
    }

    public static ThreadPoolSupplier create(ThreadPoolConfig config) {
        return new ThreadPoolSupplier(config);
    }

    public static ThreadPoolSupplier create(Consumer<ThreadPoolConfig.Builder> consumer) {
        return ThreadPoolSupplier.builder().update(consumer).build();
    }

    @Override
    public ThreadPoolConfig prototype() {
        return this.config;
    }

    ExecutorService getThreadPool() {
        if (this.useVirtualThreads) {
            ThreadFactory factory = Thread.ofVirtual().name(this.name + "-", 0L).factory();
            return ObserverManager.registerExecutorService(this, Executors.newThreadPerTaskExecutor(factory));
        }
        ThreadPool result = ThreadPool.create(this.name, this.corePoolSize, this.maxPoolSize, this.growthThreshold, this.growthRate, this.keepAliveMinutes, TimeUnit.MINUTES, this.queueCapacity, this.threadNamePrefix, this.isDaemon, this.rejectionHandler);
        if (this.prestart) {
            result.prestartAllCoreThreads();
        }
        return ObserverManager.registerExecutorService(this, result);
    }

    @Override
    public ExecutorService get() {
        return (ExecutorService)this.lazyValue.get();
    }

    public int corePoolSize() {
        return this.corePoolSize;
    }
}

