/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.configurable.ScheduledThreadPoolConfigBlueprint;
import io.helidon.common.configurable.ScheduledThreadPoolSupplier;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.configurable.ScheduledThreadPoolConfigBlueprint")
public interface ScheduledThreadPoolConfig
extends ScheduledThreadPoolConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ScheduledThreadPoolConfig instance) {
        return (Builder)ScheduledThreadPoolConfig.builder().from(instance);
    }

    public static ScheduledThreadPoolConfig create(Config config) {
        return ((Builder)ScheduledThreadPoolConfig.builder().config(config)).buildPrototype();
    }

    public static ScheduledThreadPoolConfig create() {
        return ScheduledThreadPoolConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ScheduledThreadPoolConfig>
    implements io.helidon.common.Builder<Builder, ScheduledThreadPoolSupplier> {
        private Builder() {
        }

        @Override
        public ScheduledThreadPoolConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ScheduledThreadPoolConfigImpl(this);
        }

        @Override
        public ScheduledThreadPoolSupplier build() {
            return ScheduledThreadPoolSupplier.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ScheduledThreadPoolConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean daemon = true;
        private boolean prestart = false;
        private boolean virtualThreads;
        private Config config;
        private int corePoolSize = 16;
        private String threadNamePrefix = "helidon-";

        protected BuilderBase() {
        }

        public BUILDER from(ScheduledThreadPoolConfig prototype) {
            this.virtualThreads(prototype.virtualThreads());
            this.corePoolSize(prototype.corePoolSize());
            this.daemon(prototype.daemon());
            this.threadNamePrefix(prototype.threadNamePrefix());
            this.prestart(prototype.prestart());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.virtualThreads(builder.virtualThreads());
            this.corePoolSize(builder.corePoolSize());
            this.daemon(builder.daemon());
            this.threadNamePrefix(builder.threadNamePrefix());
            this.prestart(builder.prestart());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("virtual-threads").as(Boolean.class).ifPresent(this::virtualThreads);
            config.get("core-pool-size").as(Integer.class).ifPresent(this::corePoolSize);
            config.get("is-daemon").as(Boolean.class).ifPresent(this::daemon);
            config.get("thread-name-prefix").as(String.class).ifPresent(this::threadNamePrefix);
            config.get("prestart").as(Boolean.class).ifPresent(this::prestart);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER virtualThreads(boolean virtualThreads) {
            this.virtualThreads = virtualThreads;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER daemon(boolean daemon) {
            this.daemon = daemon;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER threadNamePrefix(String threadNamePrefix) {
            Objects.requireNonNull(threadNamePrefix);
            this.threadNamePrefix = threadNamePrefix;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER prestart(boolean prestart) {
            this.prestart = prestart;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean virtualThreads() {
            return this.virtualThreads;
        }

        public int corePoolSize() {
            return this.corePoolSize;
        }

        public boolean daemon() {
            return this.daemon;
        }

        public String threadNamePrefix() {
            return this.threadNamePrefix;
        }

        public boolean prestart() {
            return this.prestart;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ScheduledThreadPoolConfigBuilder{virtualThreads=" + this.virtualThreads + ",corePoolSize=" + this.corePoolSize + ",daemon=" + this.daemon + ",threadNamePrefix=" + this.threadNamePrefix + ",prestart=" + this.prestart + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class ScheduledThreadPoolConfigImpl
        implements ScheduledThreadPoolConfig,
        Supplier<ScheduledThreadPoolSupplier> {
            private final boolean daemon;
            private final boolean prestart;
            private final boolean virtualThreads;
            private final int corePoolSize;
            private final String threadNamePrefix;

            protected ScheduledThreadPoolConfigImpl(BuilderBase<?, ?> builder) {
                this.virtualThreads = builder.virtualThreads();
                this.corePoolSize = builder.corePoolSize();
                this.daemon = builder.daemon();
                this.threadNamePrefix = builder.threadNamePrefix();
                this.prestart = builder.prestart();
            }

            @Override
            public ScheduledThreadPoolSupplier build() {
                return ScheduledThreadPoolSupplier.create(this);
            }

            @Override
            public ScheduledThreadPoolSupplier get() {
                return this.build();
            }

            @Override
            public boolean virtualThreads() {
                return this.virtualThreads;
            }

            @Override
            public int corePoolSize() {
                return this.corePoolSize;
            }

            @Override
            public boolean daemon() {
                return this.daemon;
            }

            @Override
            public String threadNamePrefix() {
                return this.threadNamePrefix;
            }

            @Override
            public boolean prestart() {
                return this.prestart;
            }

            public String toString() {
                return "ScheduledThreadPoolConfig{virtualThreads=" + this.virtualThreads + ",corePoolSize=" + this.corePoolSize + ",daemon=" + this.daemon + ",threadNamePrefix=" + this.threadNamePrefix + ",prestart=" + this.prestart + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ScheduledThreadPoolConfig)) {
                    return false;
                }
                ScheduledThreadPoolConfig other = (ScheduledThreadPoolConfig)o;
                return this.virtualThreads == other.virtualThreads() && this.corePoolSize == other.corePoolSize() && this.daemon == other.daemon() && Objects.equals(this.threadNamePrefix, other.threadNamePrefix()) && this.prestart == other.prestart();
            }

            public int hashCode() {
                return Objects.hash(this.virtualThreads, this.corePoolSize, this.daemon, this.threadNamePrefix, this.prestart);
            }
        }
    }
}

