/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.configurable.Resource;
import io.helidon.common.configurable.ResourceBuilderDecorator;
import io.helidon.common.configurable.ResourceConfigBlueprint;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.configurable.ResourceConfigBlueprint")
public interface ResourceConfig
extends ResourceConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceConfig instance) {
        return (Builder)ResourceConfig.builder().from(instance);
    }

    public static ResourceConfig create(Config config) {
        return ((Builder)ResourceConfig.builder().config(config)).buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ResourceConfig>
    implements io.helidon.common.Builder<Builder, Resource> {
        private Builder() {
        }

        @Override
        public ResourceConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ResourceConfigImpl(this);
        }

        @Override
        public Resource build() {
            return Resource.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ResourceConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean useProxy = true;
        private Config config;
        private int proxyPort = 80;
        private Path path;
        private Proxy proxy;
        private String content;
        private String contentPlain;
        private String description = "";
        private String proxyHost;
        private String resourcePath;
        private URI uri;

        protected BuilderBase() {
        }

        public BUILDER from(ResourceConfig prototype) {
            this.resourcePath(prototype.resourcePath());
            this.path(prototype.path());
            this.contentPlain(prototype.contentPlain());
            this.content(prototype.content());
            this.uri(prototype.uri());
            this.proxyHost(prototype.proxyHost());
            this.proxyPort(prototype.proxyPort());
            this.useProxy(prototype.useProxy());
            this.proxy(prototype.proxy());
            this.description(prototype.description());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.resourcePath().ifPresent(this::resourcePath);
            builder.path().ifPresent(this::path);
            builder.contentPlain().ifPresent(this::contentPlain);
            builder.content().ifPresent(this::content);
            builder.uri().ifPresent(this::uri);
            builder.proxyHost().ifPresent(this::proxyHost);
            this.proxyPort(builder.proxyPort());
            this.useProxy(builder.useProxy());
            builder.proxy().ifPresent(this::proxy);
            this.description(builder.description());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("resource-path").as(String.class).ifPresent(this::resourcePath);
            config.get("path").as(Path.class).ifPresent(this::path);
            config.get("content-plain").as(String.class).ifPresent(this::contentPlain);
            config.get("content").as(String.class).ifPresent(this::content);
            config.get("uri").as(URI.class).ifPresent(this::uri);
            config.get("proxy-host").as(String.class).ifPresent(this::proxyHost);
            config.get("proxy-port").as(Integer.class).ifPresent(this::proxyPort);
            config.get("use-proxy").as(Boolean.class).ifPresent(this::useProxy);
            config.get("description").as(String.class).ifPresent(this::description);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearResourcePath() {
            this.resourcePath = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER resourcePath(String resourcePath) {
            Objects.requireNonNull(resourcePath);
            this.resourcePath = resourcePath;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPath() {
            this.path = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER path(Path path) {
            Objects.requireNonNull(path);
            this.path = path;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearContentPlain() {
            this.contentPlain = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentPlain(String contentPlain) {
            Objects.requireNonNull(contentPlain);
            this.contentPlain = contentPlain;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearContent() {
            this.content = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER content(String content) {
            Objects.requireNonNull(content);
            this.content = content;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearUri() {
            this.uri = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER uri(URI uri) {
            Objects.requireNonNull(uri);
            this.uri = uri;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProxy() {
            this.proxy = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER proxy(Proxy proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> resourcePath() {
            return Optional.ofNullable(this.resourcePath);
        }

        public Optional<Path> path() {
            return Optional.ofNullable(this.path);
        }

        public Optional<String> contentPlain() {
            return Optional.ofNullable(this.contentPlain);
        }

        public Optional<String> content() {
            return Optional.ofNullable(this.content);
        }

        public Optional<URI> uri() {
            return Optional.ofNullable(this.uri);
        }

        public Optional<String> proxyHost() {
            return Optional.ofNullable(this.proxyHost);
        }

        public int proxyPort() {
            return this.proxyPort;
        }

        public boolean useProxy() {
            return this.useProxy;
        }

        public Optional<Proxy> proxy() {
            return Optional.ofNullable(this.proxy);
        }

        public String description() {
            return this.description;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ResourceConfigBuilder{resourcePath=" + this.resourcePath + ",path=" + String.valueOf(this.path) + ",contentPlain=" + this.contentPlain + ",content=" + this.content + ",uri=" + String.valueOf(this.uri) + ",proxyHost=" + this.proxyHost + ",proxyPort=" + this.proxyPort + ",useProxy=" + this.useProxy + ",proxy=" + String.valueOf(this.proxy) + ",description=" + this.description + "}";
        }

        protected void preBuildPrototype() {
            new ResourceBuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER resourcePath(Optional<String> resourcePath) {
            Objects.requireNonNull(resourcePath);
            this.resourcePath = resourcePath.map(String.class::cast).orElse(this.resourcePath);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER path(Optional<? extends Path> path) {
            Objects.requireNonNull(path);
            this.path = path.map(Path.class::cast).orElse(this.path);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER contentPlain(Optional<String> contentPlain) {
            Objects.requireNonNull(contentPlain);
            this.contentPlain = contentPlain.map(String.class::cast).orElse(this.contentPlain);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER content(Optional<String> content) {
            Objects.requireNonNull(content);
            this.content = content.map(String.class::cast).orElse(this.content);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER uri(Optional<? extends URI> uri) {
            Objects.requireNonNull(uri);
            this.uri = uri.map(URI.class::cast).orElse(this.uri);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER proxyHost(Optional<String> proxyHost) {
            Objects.requireNonNull(proxyHost);
            this.proxyHost = proxyHost.map(String.class::cast).orElse(this.proxyHost);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER clearProxyHost() {
            this.proxyHost = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER proxyHost(String proxyHost) {
            Objects.requireNonNull(proxyHost);
            this.proxyHost = proxyHost;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER useProxy(boolean useProxy) {
            this.useProxy = useProxy;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER proxy(Optional<? extends Proxy> proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy.map(Proxy.class::cast).orElse(this.proxy);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ResourceConfigImpl
        implements ResourceConfig,
        Supplier<Resource> {
            private final boolean useProxy;
            private final int proxyPort;
            private final Optional<String> content;
            private final Optional<String> contentPlain;
            private final Optional<String> proxyHost;
            private final Optional<String> resourcePath;
            private final Optional<Proxy> proxy;
            private final Optional<URI> uri;
            private final Optional<Path> path;
            private final String description;

            protected ResourceConfigImpl(BuilderBase<?, ?> builder) {
                this.resourcePath = builder.resourcePath();
                this.path = builder.path();
                this.contentPlain = builder.contentPlain();
                this.content = builder.content();
                this.uri = builder.uri();
                this.proxyHost = builder.proxyHost();
                this.proxyPort = builder.proxyPort();
                this.useProxy = builder.useProxy();
                this.proxy = builder.proxy();
                this.description = builder.description();
            }

            @Override
            public Resource build() {
                return Resource.create(this);
            }

            @Override
            public Resource get() {
                return this.build();
            }

            @Override
            public Optional<String> resourcePath() {
                return this.resourcePath;
            }

            @Override
            public Optional<Path> path() {
                return this.path;
            }

            @Override
            public Optional<String> contentPlain() {
                return this.contentPlain;
            }

            @Override
            public Optional<String> content() {
                return this.content;
            }

            @Override
            public Optional<URI> uri() {
                return this.uri;
            }

            @Override
            public Optional<String> proxyHost() {
                return this.proxyHost;
            }

            @Override
            public int proxyPort() {
                return this.proxyPort;
            }

            @Override
            public boolean useProxy() {
                return this.useProxy;
            }

            @Override
            public Optional<Proxy> proxy() {
                return this.proxy;
            }

            @Override
            public String description() {
                return this.description;
            }

            public String toString() {
                return "ResourceConfig{resourcePath=" + String.valueOf(this.resourcePath) + ",path=" + String.valueOf(this.path) + ",contentPlain=" + String.valueOf(this.contentPlain) + ",content=" + String.valueOf(this.content) + ",uri=" + String.valueOf(this.uri) + ",proxyHost=" + String.valueOf(this.proxyHost) + ",proxyPort=" + this.proxyPort + ",useProxy=" + this.useProxy + ",proxy=" + String.valueOf(this.proxy) + ",description=" + this.description + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ResourceConfig)) {
                    return false;
                }
                ResourceConfig other = (ResourceConfig)o;
                return Objects.equals(this.resourcePath, other.resourcePath()) && Objects.equals(this.path, other.path()) && Objects.equals(this.contentPlain, other.contentPlain()) && Objects.equals(this.content, other.content()) && Objects.equals(this.uri, other.uri()) && Objects.equals(this.proxyHost, other.proxyHost()) && this.proxyPort == other.proxyPort() && this.useProxy == other.useProxy() && Objects.equals(this.proxy, other.proxy()) && Objects.equals(this.description, other.description());
            }

            public int hashCode() {
                return Objects.hash(this.resourcePath, this.path, this.contentPlain, this.content, this.uri, this.proxyHost, this.proxyPort, this.useProxy, this.proxy, this.description);
            }
        }
    }
}

