/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.Prototype;
import io.helidon.common.configurable.ResourceConfig;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Optional;

class ResourceBuilderDecorator
implements Prototype.BuilderDecorator<ResourceConfig.BuilderBase<?, ?>> {
    ResourceBuilderDecorator() {
    }

    @Override
    public void decorate(ResourceConfig.BuilderBase<?, ?> target) {
        boolean useProxy = target.useProxy();
        if (!useProxy) {
            target.proxy(Optional.empty());
            return;
        }
        if (target.proxy().isPresent()) {
            return;
        }
        if (target.proxyHost().isPresent()) {
            String proxyHost = target.proxyHost().get();
            int port = target.proxyPort();
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, port));
            target.proxy(proxy);
        }
    }
}

