/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.config.Config;
import io.helidon.common.configurable.AllowListConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;

@RuntimeType.PrototypedBy(value=AllowListConfig.class)
public class AllowList
implements Predicate<String>,
RuntimeType.Api<AllowListConfig> {
    private static final System.Logger LOGGER = System.getLogger(AllowList.class.getName());
    private static final String ALLOWED_MATCHED_LOG_FORMAT = "Value '%s' is allowed by %s";
    private static final String DENIED_MATCHED_LOG_FORMAT = " but is denied by %s";
    private final List<Predicate<String>> allowedPredicates = new ArrayList<Predicate<String>>();
    private final List<Predicate<String>> deniedPredicates = new ArrayList<Predicate<String>>();
    private final AllowListConfig config;

    AllowList(AllowListConfig config) {
        this.config = config;
        this.allowedPredicates.addAll(config.allowedPredicates());
        this.deniedPredicates.addAll(config.deniedPredicates());
        config.allowed().forEach(it -> this.allowedPredicates.add(new ExactPredicate((String)it)));
        config.denied().forEach(it -> this.deniedPredicates.add(new ExactPredicate((String)it)));
        config.allowedPrefixes().forEach(it -> this.allowedPredicates.add(new PrefixPredicate((String)it)));
        config.deniedPrefixes().forEach(it -> this.deniedPredicates.add(new PrefixPredicate((String)it)));
        config.allowedSuffixes().forEach(it -> this.allowedPredicates.add(new SuffixPredicate((String)it)));
        config.deniedSuffixes().forEach(it -> this.deniedPredicates.add(new SuffixPredicate((String)it)));
        config.allowedPatterns().forEach(it -> this.allowedPredicates.add(new PatternPredicate((Pattern)it)));
        config.deniedPatterns().forEach(it -> this.deniedPredicates.add(new PatternPredicate((Pattern)it)));
        if (config.allowAll()) {
            if (!this.allowedPredicates.isEmpty()) {
                LOGGER.log(System.Logger.Level.INFO, this.getClass().getSimpleName() + " allowAll=true overrides the other, more specific, allow predicates");
                this.allowedPredicates.clear();
            }
            this.allowedPredicates.add(new AllowAllPredicate());
        }
    }

    public static AllowListConfig.Builder builder() {
        return AllowListConfig.builder();
    }

    public static AllowList create(Config config) {
        return ((AllowListConfig.Builder)AllowList.builder().config(config)).build();
    }

    public static AllowList create(AllowListConfig config) {
        return new AllowList(config);
    }

    public static AllowList create(Consumer<AllowListConfig.Builder> consumer) {
        AllowListConfig.Builder builder = AllowListConfig.builder();
        consumer.accept(builder);
        return builder.build();
    }

    @Override
    public AllowListConfig prototype() {
        return this.config;
    }

    @Override
    public boolean test(String value) {
        for (Predicate<String> allowedPredicate : this.allowedPredicates) {
            if (!allowedPredicate.test(value)) continue;
            Predicate<String> deniedPredicate = this.testNotDenied(value);
            if (deniedPredicate == null) {
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, String.format(ALLOWED_MATCHED_LOG_FORMAT, value, allowedPredicate));
                }
                return true;
            }
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, String.format("Value '%s' is allowed by %s but is denied by %s", value, allowedPredicate, deniedPredicate));
            }
            return false;
        }
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Denying value '" + value + "'; no matching allow predicates are defined");
        }
        return false;
    }

    public String toString() {
        return "Allowed: " + String.valueOf(this.allowedPredicates) + ", Denied: " + String.valueOf(this.deniedPredicates);
    }

    private Predicate<String> testNotDenied(String value) {
        for (Predicate<String> deniedPredicate : this.deniedPredicates) {
            if (!deniedPredicate.test(value)) continue;
            return deniedPredicate;
        }
        return null;
    }

    private static final class AllowAllPredicate
    implements Predicate<String> {
        private AllowAllPredicate() {
        }

        @Override
        public boolean test(String s) {
            return true;
        }

        public String toString() {
            return "AllowAllPredicate";
        }
    }

    private static final class PatternPredicate
    implements Predicate<String> {
        private final Pattern testPattern;

        private PatternPredicate(Pattern testPattern) {
            this.testPattern = testPattern;
        }

        @Override
        public boolean test(String value) {
            return this.testPattern.matcher(value).matches();
        }

        public String toString() {
            return "Pattern(" + this.testPattern.pattern() + ")";
        }
    }

    private static final class SuffixPredicate
    implements Predicate<String> {
        private final String testValue;

        private SuffixPredicate(String testValue) {
            this.testValue = testValue;
        }

        @Override
        public boolean test(String value) {
            return value.endsWith(this.testValue);
        }

        public String toString() {
            return "Suffix(" + this.testValue + ")";
        }
    }

    private static final class PrefixPredicate
    implements Predicate<String> {
        private final String testValue;

        private PrefixPredicate(String testValue) {
            this.testValue = testValue;
        }

        @Override
        public boolean test(String value) {
            return value.startsWith(this.testValue);
        }

        public String toString() {
            return "Prefix(" + this.testValue + ")";
        }
    }

    private static final class ExactPredicate
    implements Predicate<String> {
        private final String testValue;

        ExactPredicate(String exact) {
            this.testValue = exact;
        }

        @Override
        public boolean test(String value) {
            return this.testValue.equals(value);
        }

        public String toString() {
            return "Exact(" + this.testValue + ")";
        }
    }
}

