/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.config;

import io.helidon.builder.api.Prototype;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.common.config.ConfiguredProvider;
import io.helidon.common.config.NamedService;
import io.helidon.service.registry.ServiceRegistry;
import io.helidon.service.registry.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

final class ProvidedUtil {
    private static final System.Logger PROVIDER_LOGGER = System.getLogger(Prototype.class.getName() + ".provider");
    private static final String KEY_SERVICE_TYPE = "type";
    private static final String KEY_SERVICE_NAME = "name";
    private static final String KEY_SERVICE_ENABLED = "enabled";

    private ProvidedUtil() {
    }

    static <T extends NamedService> Optional<T> discoverService(Config config, String configKey, HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean discoverServices, Optional<T> existingValue) {
        if (existingValue.isPresent()) {
            return Optional.empty();
        }
        List serviceConfigList = config.get(configKey).asNodeList().orElseGet(List::of);
        if (serviceConfigList.size() > 1) {
            throw new ConfigException("There can only be one provider configured for " + String.valueOf(config.key()));
        }
        List<T> services = ProvidedUtil.discoverServices(config, configKey, serviceLoader, providerType, configType, discoverServices, List.of());
        return services.isEmpty() ? Optional.empty() : Optional.of((NamedService)services.getFirst());
    }

    static <T extends NamedService> List<T> discoverServices(Config config, String configKey, HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean allFromServiceLoader, List<T> existingInstances) {
        HashSet<TypeAndName> ignoredServices = new HashSet<TypeAndName>();
        existingInstances.forEach(it -> ignoredServices.add(new TypeAndName(it.type(), it.name())));
        boolean discoverServices = config.get(configKey + "-discover-services").asBoolean().orElse(allFromServiceLoader);
        Config providersConfig = config.get(configKey);
        ArrayList<ConfiguredService> configuredServices = new ArrayList<ConfiguredService>();
        List serviceConfigList = providersConfig.asNodeList().orElseGet(List::of);
        boolean isList = providersConfig.isList();
        for (Config serviceConfig : serviceConfigList) {
            configuredServices.add(ProvidedUtil.configuredService(serviceConfig, isList));
        }
        if (providersConfig.isList()) {
            return ProvidedUtil.servicesFromList(serviceLoader, providerType, configType, configuredServices, discoverServices, ignoredServices);
        }
        return ProvidedUtil.servicesFromObject(providersConfig, serviceLoader, providerType, configType, configuredServices, discoverServices, ignoredServices);
    }

    static <T extends NamedService> List<T> discoverServices(Config config, String configKey, Optional<ServiceRegistry> serviceRegistry, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean allFromRegistry, List<T> existingValues) {
        RegistryWrap wrap;
        HashSet<TypeAndName> ignoredServices = new HashSet<TypeAndName>();
        existingValues.forEach(it -> ignoredServices.add(new TypeAndName(it.type(), it.name())));
        boolean discoverServices = config.get(configKey + "-discover-services").asBoolean().orElse(allFromRegistry);
        Config providersConfig = config.get(configKey);
        ArrayList<ConfiguredService> configuredServices = new ArrayList<ConfiguredService>();
        List serviceConfigList = providersConfig.asNodeList().orElseGet(List::of);
        boolean isList = providersConfig.isList();
        for (Config serviceConfig : serviceConfigList) {
            configuredServices.add(ProvidedUtil.configuredService(serviceConfig, isList));
        }
        RegistryWrap registryWrap = wrap = serviceRegistry.isPresent() ? new RealRegistry(serviceRegistry.get()) : StaticAccessRegistry.INSTANCE;
        if (providersConfig.isList()) {
            return ProvidedUtil.servicesFromList(wrap, providerType, configType, configuredServices, discoverServices, ignoredServices);
        }
        return ProvidedUtil.servicesFromObject(providersConfig, wrap, providerType, configType, configuredServices, discoverServices, ignoredServices);
    }

    static <T extends NamedService> Optional<T> discoverService(Config config, String configKey, Optional<ServiceRegistry> serviceRegistry, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean discoverServices, Optional<T> existingValue) {
        if (existingValue.isPresent()) {
            return Optional.empty();
        }
        List serviceConfigList = config.get(configKey).asNodeList().orElseGet(List::of);
        if (serviceConfigList.size() > 1) {
            throw new ConfigException("There can only be one provider configured for " + String.valueOf(config.key()));
        }
        List<T> services = ProvidedUtil.discoverServices(config, configKey, serviceRegistry, providerType, configType, discoverServices, List.of());
        return services.isEmpty() ? Optional.empty() : Optional.of((NamedService)services.getFirst());
    }

    private static <T extends NamedService> List<T> servicesFromObject(Config providersConfig, HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, List<ConfiguredService> configuredServices, boolean allFromServiceLoader, Set<TypeAndName> ignoredServices) {
        HashSet availableProviders = new HashSet();
        HashMap allConfigs = new HashMap();
        configuredServices.forEach(it -> allConfigs.put(it.typeAndName().type, it));
        HashSet unusedConfigs = new HashSet(allConfigs.keySet());
        ArrayList result = new ArrayList();
        serviceLoader.forEach(provider -> {
            ConfiguredService configuredService = (ConfiguredService)allConfigs.get(provider.configKey());
            availableProviders.add(provider.configKey());
            unusedConfigs.remove(provider.configKey());
            if (configuredService == null) {
                if (allFromServiceLoader) {
                    String type2 = provider.configKey();
                    if (ignoredServices.add(new TypeAndName(type2, type2))) {
                        result.add(provider.create(providersConfig.get(type2), type2));
                    } else if (PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                        PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(new TypeAndName(type2, type2)) + " is already added in builder, ignoring configured one.");
                    }
                }
            } else if (configuredService.enabled()) {
                if (ignoredServices.add(configuredService.typeAndName())) {
                    result.add(provider.create(configuredService.serviceConfig(), configuredService.typeAndName().name()));
                } else if (PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(configuredService.typeAndName()) + " is already added in builder, ignoring configured one.");
                }
            }
        });
        if (!unusedConfigs.isEmpty()) {
            throw new ConfigException("Unknown provider configured. Expected providers with types: " + String.valueOf(unusedConfigs) + ", but only the following providers are supported: " + String.valueOf(availableProviders) + ", provider interface: " + providerType.getName() + ", configured service: " + configType.getName());
        }
        return result;
    }

    private static <T extends NamedService> List<T> servicesFromList(HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, List<ConfiguredService> configuredServices, boolean allFromServiceLoader, Set<TypeAndName> ignoredServices) {
        HashMap allProvidersByType = new HashMap();
        LinkedHashMap<String, ConfiguredProvider> unusedProvidersByType = new LinkedHashMap<String, ConfiguredProvider>();
        serviceLoader.forEach(it -> {
            allProvidersByType.put(it.configKey(), it);
            unusedProvidersByType.put(it.configKey(), (ConfiguredProvider)it);
        });
        ArrayList result = new ArrayList();
        for (ConfiguredService service : configuredServices) {
            TypeAndName typeAndName = service.typeAndName();
            if (!ignoredServices.add(typeAndName)) {
                unusedProvidersByType.remove(typeAndName.type());
                if (!PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
                PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(typeAndName) + " is already added in builder, ignoring configured one.");
                continue;
            }
            ConfiguredProvider provider2 = (ConfiguredProvider)allProvidersByType.get(typeAndName.type());
            if (provider2 == null) {
                throw new ConfigException("Unknown provider configured. Expecting a provider with type \"" + typeAndName.type() + "\", but only the following providers are supported: " + String.valueOf(allProvidersByType.keySet()) + ", provider interface: " + providerType.getName() + ", configured service: " + configType.getName());
            }
            unusedProvidersByType.remove(typeAndName.type());
            if (!service.enabled()) continue;
            result.add(provider2.create(service.serviceConfig(), typeAndName.name()));
        }
        if (allFromServiceLoader) {
            unusedProvidersByType.forEach((type2, provider) -> {
                if (ignoredServices.add(new TypeAndName((String)type2, (String)type2))) {
                    result.add(provider.create(Config.empty(), (String)type2));
                }
            });
        }
        return result;
    }

    private static ConfiguredService configuredService(Config serviceConfig, boolean isList) {
        if (isList) {
            String type2 = serviceConfig.get(KEY_SERVICE_TYPE).asString().orElse(null);
            String name = serviceConfig.get(KEY_SERVICE_NAME).asString().orElse(type2);
            boolean enabled = serviceConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse(true);
            Config usedConfig = serviceConfig;
            if (type2 == null) {
                List configs = serviceConfig.asNodeList().orElseGet(List::of);
                if (configs.size() != 1) {
                    throw new ConfigException("Service provider configuration defined as a list must have a single node that is the type, with children containing the provider configuration. Failed on: " + String.valueOf(serviceConfig.key()));
                }
                usedConfig = (Config)configs.getFirst();
                name = usedConfig.name();
                type2 = usedConfig.get(KEY_SERVICE_TYPE).asString().orElse(name);
                enabled = usedConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse(enabled);
            }
            return new ConfiguredService(new TypeAndName(type2, name), usedConfig, enabled);
        }
        String name = serviceConfig.name();
        String type3 = serviceConfig.get(KEY_SERVICE_TYPE).asString().orElse(name);
        boolean enabled = serviceConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse(true);
        return new ConfiguredService(new TypeAndName(type3, name), serviceConfig, enabled);
    }

    private static <T extends NamedService> List<T> servicesFromList(RegistryWrap serviceRegistry, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, List<ConfiguredService> configuredServices, boolean allFromServiceLoader, Set<TypeAndName> ignoredServices) {
        HashMap allProvidersByType = new HashMap();
        LinkedHashMap<String, ConfiguredProvider> unusedProvidersByType = new LinkedHashMap<String, ConfiguredProvider>();
        serviceRegistry.all(providerType).forEach(provider -> {
            allProvidersByType.put(provider.configKey(), provider);
            unusedProvidersByType.put(provider.configKey(), (ConfiguredProvider)provider);
        });
        ArrayList result = new ArrayList();
        for (ConfiguredService service : configuredServices) {
            TypeAndName typeAndName = service.typeAndName();
            if (!ignoredServices.add(typeAndName)) {
                unusedProvidersByType.remove(typeAndName.type());
                if (!PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
                PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(typeAndName) + " is already added in builder, ignoring configured one.");
                continue;
            }
            ConfiguredProvider provider2 = (ConfiguredProvider)allProvidersByType.get(typeAndName.type());
            if (provider2 == null) {
                throw new ConfigException("Unknown provider configured. Expecting a provider with type \"" + typeAndName.type() + "\", but only the following providers are supported: " + String.valueOf(allProvidersByType.keySet()) + ", provider interface: " + providerType.getName() + ", configured service: " + configType.getName());
            }
            unusedProvidersByType.remove(typeAndName.type());
            if (!service.enabled()) continue;
            result.add(provider2.create(service.serviceConfig(), typeAndName.name()));
        }
        if (allFromServiceLoader) {
            unusedProvidersByType.forEach((type2, provider) -> {
                if (ignoredServices.add(new TypeAndName((String)type2, (String)type2))) {
                    result.add(provider.create(Config.empty(), (String)type2));
                }
            });
        }
        return result;
    }

    private static <T extends NamedService> List<T> servicesFromObject(Config providersConfig, RegistryWrap serviceRegistry, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, List<ConfiguredService> configuredServices, boolean allFromServiceLoader, Set<TypeAndName> ignoredServices) {
        HashSet<String> availableProviders = new HashSet<String>();
        HashMap allConfigs = new HashMap();
        configuredServices.forEach(it -> allConfigs.put(it.typeAndName().type, it));
        HashSet unusedConfigs = new HashSet(allConfigs.keySet());
        ArrayList<T> result = new ArrayList<T>();
        List<ConfiguredProvider<T>> all = serviceRegistry.all(providerType);
        for (ConfiguredProvider<T> provider : all) {
            ConfiguredService configuredService = (ConfiguredService)allConfigs.get(provider.configKey());
            availableProviders.add(provider.configKey());
            unusedConfigs.remove(provider.configKey());
            if (configuredService == null) {
                if (!allFromServiceLoader) continue;
                String type2 = provider.configKey();
                if (ignoredServices.add(new TypeAndName(type2, type2))) {
                    result.add(provider.create(providersConfig.get(type2), type2));
                    continue;
                }
                if (!PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
                PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(new TypeAndName(type2, type2)) + " is already added in builder, ignoring configured one.");
                continue;
            }
            if (!configuredService.enabled()) continue;
            if (ignoredServices.add(configuredService.typeAndName())) {
                result.add(provider.create(configuredService.serviceConfig(), configuredService.typeAndName().name()));
                continue;
            }
            if (!PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
            PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(configuredService.typeAndName()) + " is already added in builder, ignoring configured one.");
        }
        if (!unusedConfigs.isEmpty()) {
            throw new ConfigException("Unknown provider configured. Expected providers with types: " + String.valueOf(unusedConfigs) + ", but only the following providers are supported: " + String.valueOf(availableProviders) + ", provider interface: " + providerType.getName() + ", configured service: " + configType.getName());
        }
        return result;
    }

    private record ConfiguredService(TypeAndName typeAndName, Config serviceConfig, boolean enabled) {
    }

    private static final class RealRegistry
    implements RegistryWrap {
        private final ServiceRegistry serviceRegistry;

        private RealRegistry(ServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
        }

        @Override
        public <T> List<T> all(Class<T> type2) {
            return this.serviceRegistry.all(type2);
        }
    }

    private static final class StaticAccessRegistry
    implements RegistryWrap {
        public static final StaticAccessRegistry INSTANCE = new StaticAccessRegistry();

        private StaticAccessRegistry() {
        }

        @Override
        public <T> List<T> all(Class<T> type2) {
            return Services.all(type2);
        }
    }

    private static interface RegistryWrap {
        public <T> List<T> all(Class<T> var1);
    }

    private record TypeAndName(String type, String name) {
    }
}

