/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.config;

import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.common.config.ConfigValue;
import io.helidon.common.mapper.MapperException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

final class EmptyConfig {
    static final Config.Key ROOT_KEY = new KeyImpl(null, "");
    static final Config EMPTY = new EmptyNode(ROOT_KEY);

    private EmptyConfig() {
    }

    private static final class KeyImpl
    implements Config.Key {
        private final Config.Key parent;
        private final String name;

        private KeyImpl(Config.Key parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        @Override
        public Config.Key parent() throws ConfigException {
            if (this.isRoot()) {
                throw new IllegalStateException("Attempting to get parent of a root node. Guard by isRoot instead");
            }
            return this.parent;
        }

        @Override
        public boolean isRoot() {
            return this.parent == null;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Config.Key child(Config.Key key) {
            if (this.isRoot()) {
                return key;
            }
            List<String> path = KeyImpl.path(key);
            KeyImpl node = this;
            for (String name : path) {
                node = new KeyImpl(node, name);
            }
            return node;
        }

        @Override
        public int compareTo(Config.Key o) {
            return this.toString().compareTo(o.toString());
        }

        @Override
        public String toString() {
            return String.join((CharSequence)".", KeyImpl.path(this));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyImpl key = (KeyImpl)o;
            return Objects.equals(this.parent, key.parent) && Objects.equals(this.name, key.name);
        }

        public int hashCode() {
            return Objects.hash(this.parent, this.name);
        }

        private static List<String> path(Config.Key key) {
            ArrayList<String> names = new ArrayList<String>();
            Config.Key node = key;
            while (!node.isRoot()) {
                names.add(node.name());
                node = node.parent();
            }
            Collections.reverse(names);
            return names;
        }
    }

    private static final class EmptyNode
    implements Config {
        private final Config.Key key;

        private EmptyNode(Config.Key key) {
            this.key = key;
        }

        @Override
        public Config.Key key() {
            return this.key;
        }

        @Override
        public Config root() {
            return EMPTY;
        }

        @Override
        public Config get(Config.Key key) throws ConfigException {
            return new EmptyNode(this.key.child(key));
        }

        @Override
        public Config get(String key) throws ConfigException {
            String[] split = key.split("\\.");
            Config.Key node = this.key;
            for (String s : split) {
                node = new KeyImpl(node, s);
            }
            return new EmptyNode(node);
        }

        @Override
        public Config detach() throws ConfigException {
            return EMPTY;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public boolean isObject() {
            return false;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean hasValue() {
            return false;
        }

        @Override
        public <T> ConfigValue<T> as(Class<T> type2) {
            return new EmptyValue(this.key);
        }

        @Override
        public <T> ConfigValue<T> map(Function<Config, T> mapper) {
            return new EmptyValue(this.key);
        }

        @Override
        public <T> ConfigValue<List<T>> asList(Class<T> type2) throws ConfigException {
            return new EmptyValue<List<T>>(this.key);
        }

        @Override
        public <T> ConfigValue<List<T>> mapList(Function<Config, T> mapper) throws ConfigException {
            return new EmptyValue<List<T>>(this.key);
        }

        @Override
        public <C extends Config> ConfigValue<List<C>> asNodeList() throws ConfigException {
            return new EmptyValue<List<C>>(this.key);
        }

        @Override
        public ConfigValue<Map<String, String>> asMap() throws ConfigException {
            return new EmptyValue<Map<String, String>>(this.key);
        }
    }

    private static final class EmptyValue<T>
    implements ConfigValue<T> {
        private final Config.Key key;

        private EmptyValue(Config.Key key) {
            this.key = key;
        }

        @Override
        public Config.Key key() {
            return this.key;
        }

        @Override
        public Optional<T> asOptional() throws ConfigException {
            return Optional.empty();
        }

        @Override
        public T get() throws ConfigException {
            throw new ConfigException("Config node " + this.key.name() + " is empty");
        }

        @Override
        public <N> ConfigValue<N> as(Function<? super T, ? extends N> mapper) {
            return new EmptyValue<T>(this.key);
        }

        @Override
        public <N> ConfigValue<N> as(GenericType<N> type2) throws MapperException {
            return new EmptyValue<T>(this.key);
        }

        @Override
        public Supplier<T> supplier() {
            return this::get;
        }

        @Override
        public Supplier<T> supplier(T defaultValue) {
            return () -> defaultValue;
        }

        @Override
        public Supplier<Optional<T>> optionalSupplier() {
            return this::asOptional;
        }

        @Override
        public <N> ConfigValue<N> as(Class<N> type2) throws MapperException {
            return null;
        }
    }
}

