/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.Weight;
import io.helidon.common.Weighted;
import java.util.Comparator;
import java.util.List;

public final class Weights {
    private static final double INVALID_WEIGHT = -101.0;

    private Weights() {
    }

    public static double find(Class<?> aClass, double defaultWeight) {
        Weight weightAnnot = aClass.getAnnotation(Weight.class);
        if (null != weightAnnot) {
            return weightAnnot.value();
        }
        return defaultWeight;
    }

    public static double find(Object anObject, double defaultWeight) {
        if (anObject instanceof Class) {
            return Weights.find((Class)anObject, defaultWeight);
        }
        if (anObject instanceof Weighted) {
            return ((Weighted)anObject).weight();
        }
        Weight weight = null;
        Class<?> current = anObject.getClass();
        while (weight == null) {
            weight = current.getAnnotation(Weight.class);
            if (!(current = current.getSuperclass()).equals(Object.class)) continue;
        }
        if (weight == null) {
            Class<?> anInterface;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = anObject.getClass().getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (weight = (anInterface = classArray[i]).getAnnotation(Weight.class)) == null; ++i) {
            }
        }
        if (weight == null) {
            return defaultWeight;
        }
        return weight.value();
    }

    public static void sort(List<?> list) {
        list.sort(Weights.weightComparator());
    }

    public static <S> Comparator<S> weightComparator() {
        return (o1, o2) -> {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            double firstWeight = Weights.find(o1, -101.0);
            double secondWeight = Weights.find(o2, -101.0);
            if (firstWeight != -101.0 && secondWeight != -101.0 && firstWeight != secondWeight) {
                return Double.compare(secondWeight, firstWeight);
            }
            if (firstWeight != -101.0 && secondWeight != -101.0) {
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
            if (firstWeight != -101.0) {
                return -1;
            }
            if (secondWeight != -101.0) {
                return 1;
            }
            int result = o1.getClass().getName().compareTo(o2.getClass().getName());
            if (result != 0) {
                return result;
            }
            return o1.toString().compareTo(o2.toString());
        };
    }
}

