/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Stack;

final class GenericTypeUtil {
    private GenericTypeUtil() {
    }

    static Type typeArgument(Class<?> clazz, Class<?> baseClass) {
        ParameterizedType pt;
        Class rawType;
        int argIndex;
        Type currentType;
        Stack<Type> superclasses = new Stack<Type>();
        Class currentClass = clazz;
        do {
            currentType = currentClass.getGenericSuperclass();
            superclasses.push(currentType);
            if (currentType instanceof Class) {
                currentClass = (Class)currentType;
                continue;
            }
            if (!(currentType instanceof ParameterizedType)) continue;
            currentClass = (Class)((ParameterizedType)currentType).getRawType();
        } while (!currentClass.equals(Object.class) && !currentClass.equals(baseClass));
        TypeVariable tv = baseClass.getTypeParameters()[0];
        while (!superclasses.isEmpty() && (currentType = (Type)superclasses.pop()) instanceof ParameterizedType && (argIndex = Arrays.asList((rawType = (Class)(pt = (ParameterizedType)currentType).getRawType()).getTypeParameters()).indexOf(tv)) > -1) {
            Type typeArg = pt.getActualTypeArguments()[argIndex];
            if (typeArg instanceof TypeVariable) {
                tv = (TypeVariable)typeArg;
                continue;
            }
            return typeArg;
        }
        throw new IllegalArgumentException(String.valueOf(currentType) + " does not specify the type parameter T of GenericType<T>");
    }

    static Class<?> rawClass(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            if (parameterizedType.getRawType() instanceof Class) {
                return (Class)parameterizedType.getRawType();
            }
        } else if (type2 instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type2;
            Class<?> componentRawType = GenericTypeUtil.rawClass(array.getGenericComponentType());
            return GenericTypeUtil.getArrayClass(componentRawType);
        }
        throw new IllegalArgumentException("Type parameter " + String.valueOf(type2) + " is not a class or parameterized type whose raw type is a class");
    }

    private static Class<?> getArrayClass(Class<?> c) {
        try {
            Object o = Array.newInstance(c, 0);
            return o.getClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

