/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.ee.web.integration.WebPrincipal;
import com.sun.enterprise.security.ee.web.integration.WebProgrammaticLogin;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.RequestFacade;
import org.jvnet.hk2.annotations.Service;

@Service
public class WebProgrammaticLoginImpl
implements WebProgrammaticLogin {
    public static final String WEBAUTH_PROGRAMMATIC = "PROGRAMMATIC";
    private static final Logger LOG = Logger.getLogger(WebProgrammaticLoginImpl.class.getName());

    @Override
    public Boolean login(String user, char[] password, String realm, HttpServletRequest request, HttpServletResponse response) {
        Request coyoteRequest = WebProgrammaticLoginImpl.getUnwrappedCoyoteRequest(request);
        if (coyoteRequest == null) {
            return false;
        }
        LoginContextDriver.login(user, password, realm);
        SecurityContext secCtx = SecurityContext.getCurrent();
        assert (secCtx != null);
        WebPrincipal principal = new WebPrincipal(user, password, secCtx);
        coyoteRequest.setUserPrincipal(principal);
        coyoteRequest.setAuthType(WEBAUTH_PROGRAMMATIC);
        LOG.log(Level.FINE, "Programmatic login set principal in http request to: {0}", user);
        Session realSession = WebProgrammaticLoginImpl.getSession(coyoteRequest);
        if (realSession != null) {
            realSession.setPrincipal(principal);
            realSession.setAuthType(WEBAUTH_PROGRAMMATIC);
            LOG.log(Level.FINE, "Programmatic login set principal in session.");
        } else {
            LOG.log(Level.FINE, "Programmatic login: No session available.");
        }
        return true;
    }

    private static Request getUnwrappedCoyoteRequest(HttpServletRequest request) {
        Request coyoteRequest = null;
        ServletRequest servletRequest = request;
        try {
            HttpServletRequest prevRequest = null;
            while (servletRequest != prevRequest && servletRequest instanceof ServletRequestWrapper) {
                prevRequest = servletRequest;
                servletRequest = ((ServletRequestWrapper)servletRequest).getRequest();
            }
            if (servletRequest instanceof RequestFacade) {
                coyoteRequest = ((RequestFacade)servletRequest).getUnwrappedCoyoteRequest();
            }
        }
        catch (AccessControlException ex) {
            LOG.log(Level.FINE, "Programmatic login faiied to get request", ex);
        }
        return coyoteRequest;
    }

    @Override
    public Boolean logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Request coyoteRequest = WebProgrammaticLoginImpl.getUnwrappedCoyoteRequest(request);
        if (coyoteRequest == null) {
            return false;
        }
        LoginContextDriver.logout();
        coyoteRequest.setUserPrincipal(null);
        coyoteRequest.setAuthType(null);
        LOG.log(Level.FINE, "Programmatic logout removed principal from request.");
        Session realSession = WebProgrammaticLoginImpl.getSession(coyoteRequest);
        if (realSession != null) {
            realSession.setPrincipal(null);
            realSession.setAuthType(null);
            LOG.log(Level.FINE, "Programmatic logout removed principal from session.");
        }
        return true;
    }

    private static Session getSession(Request request) {
        Manager manager;
        Context context;
        HttpSession session = request.getSession(false);
        if (session != null && (context = request.getContext()) != null && (manager = context.getManager()) != null) {
            String sessionId = session.getId();
            try {
                return manager.findSession(sessionId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

