/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.TextRenderer;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.html.HtmlInputFile;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.ConverterException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class FileRenderer
extends TextRenderer {
    @Override
    public void decode(FacesContext context, UIComponent component) {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldDecode(component)) {
            return;
        }
        String clientId = this.decodeBehaviors(context, component);
        if (clientId == null) {
            clientId = component.getClientId(context);
        }
        assert (clientId != null);
        ExternalContext externalContext = context.getExternalContext();
        Map<String, String> requestMap = externalContext.getRequestParameterMap();
        if (requestMap.containsKey(clientId)) {
            this.setSubmittedValue(component, requestMap.get(clientId));
        }
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        try {
            Collection<Part> parts = request.getParts();
            ArrayList<Part> submittedValues = new ArrayList<Part>();
            for (Part cur : parts) {
                if (!clientId.equals(cur.getName())) continue;
                submittedValues.add(cur);
            }
            if (((HtmlInputFile)component).isMultiple()) {
                this.setSubmittedValue(component, submittedValues);
            } else if (!submittedValues.isEmpty()) {
                this.setSubmittedValue(component, submittedValues.iterator().next());
            }
        }
        catch (ServletException | IOException ioe) {
            throw new FacesException(ioe);
        }
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context.isProjectStage(ProjectStage.Development)) {
            boolean produceMessage = false;
            UIForm form = RenderKitUtils.getForm(component, context);
            if (null != form) {
                String encType = (String)form.getAttributes().get("enctype");
                if (null == encType || !encType.equals("multipart/form-data")) {
                    produceMessage = true;
                }
            } else {
                produceMessage = true;
            }
            if (produceMessage) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_WARN, "File upload component requires a form with an enctype of multipart/form-data", "File upload component requires a form with an enctype of multipart/form-data");
                context.addMessage(component.getClientId(context), message);
            }
        }
        super.encodeBegin(context, component);
    }

    @Override
    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
        super.getEndTextToRender(context, component, null);
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Part) {
            Part part2 = (Part)submittedValue;
            if (FileRenderer.isEmpty(part2)) {
                return null;
            }
        } else if (submittedValue instanceof Collection) {
            Collection parts = (Collection)submittedValue;
            return Collections.unmodifiableList(parts.stream().filter(part -> !FileRenderer.isEmpty(part)).collect(Collectors.toList()));
        }
        return submittedValue;
    }

    private static boolean isEmpty(Part part) {
        return part.getSubmittedFileName() == null || part.getSubmittedFileName().isEmpty() || part.getSize() <= 0L;
    }
}

