/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.flow.FlowDiscoveryCDIHelper;
import com.sun.faces.util.FacesLogger;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.Producer;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.builder.FlowDefinition;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlowDiscoveryCDIExtension
implements Extension {
    private static final Logger LOGGER = FacesLogger.FLOW.getLogger();
    private List<Producer<Flow>> flowProducers = new CopyOnWriteArrayList<Producer<Flow>>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        CdiUtils.addAnnotatedTypes(beforeBeanDiscovery, beanManager, FlowDiscoveryCDIHelper.class);
    }

    void findFlowDefiners(@Observes ProcessProducer<?, Flow> processProducer) {
        if (processProducer.getAnnotatedMember().isAnnotationPresent(FlowDefinition.class)) {
            this.flowProducers.add(processProducer.getProducer());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Discovered Flow Producer {0}", processProducer.getProducer().toString());
            }
        }
    }

    public List<Producer<Flow>> getFlowProducers() {
        return this.flowProducers;
    }
}

