/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.AttributeHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import java.io.IOException;
import java.util.Map;

public final class PassThroughAttributeHandler
extends TagHandlerImpl
implements AttributeHandler {
    private final TagAttribute name = this.getRequiredAttribute("name");
    private final TagAttribute value = this.getRequiredAttribute("value");

    public PassThroughAttributeHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null) {
            throw new TagException(this.tag, "Parent UIComponent was null");
        }
        if (parent.getParent() == null) {
            Map<String, Object> passThroughAttrs = parent.getPassThroughAttributes(true);
            String attrName = this.name.getValue(ctx);
            Object attrValue = this.value.isLiteral() ? this.value.getValue(ctx) : this.value.getValueExpression(ctx, Object.class);
            passThroughAttrs.put(attrName, attrValue);
        }
    }

    @Override
    public String getAttributeName(FaceletContext ctxt) {
        return this.name.getValue(ctxt);
    }
}

