/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import com.sun.faces.component.CompositeComponentStackManager;
import com.sun.faces.facelets.el.ContextualCompositeValueExpression;
import com.sun.faces.facelets.el.TagValueExpression;
import com.sun.faces.util.FacesLogger;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.validator.ValidatorException;
import jakarta.faces.view.Location;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContextualCompositeMethodExpression
extends MethodExpression {
    private static final long serialVersionUID = -6281398928485392830L;
    private static final Logger LOGGER = FacesLogger.FACELETS_EL.getLogger();
    private final MethodExpression delegate;
    private final ValueExpression source;
    private final Location location;
    private String ccClientId;

    public ContextualCompositeMethodExpression(ValueExpression source, MethodExpression delegate) {
        this.delegate = delegate;
        this.source = source;
        this.location = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        UIComponent cc = UIComponent.getCurrentCompositeComponent(ctx);
        cc.subscribeToEvent(PostAddToViewEvent.class, new SetClientIdListener(this));
    }

    public ContextualCompositeMethodExpression(Location location, MethodExpression delegate) {
        this.delegate = delegate;
        this.location = location;
        this.source = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        UIComponent cc = UIComponent.getCurrentCompositeComponent(ctx);
        cc.subscribeToEvent(PostAddToViewEvent.class, new SetClientIdListener(this));
    }

    @Override
    public MethodInfo getMethodInfo(ELContext elContext) {
        return this.delegate.getMethodInfo(elContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(ELContext elContext, Object[] objects) {
        FacesContext ctx = (FacesContext)elContext.getContext(FacesContext.class);
        boolean pushed = this.pushCompositeComponent(ctx);
        try {
            Object object = this.delegate.invoke(elContext, objects);
            if (pushed) {
                this.popCompositeComponent(ctx);
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (pushed) {
                    this.popCompositeComponent(ctx);
                }
                throw throwable;
            }
            catch (ELException ele) {
                block14: {
                    if (ele.getCause() != null && ele.getCause() instanceof ValidatorException) {
                        throw (ValidatorException)ele.getCause();
                    }
                    if (this.source != null && ele instanceof MethodNotFoundException) {
                        try {
                            Object fallback = this.source.getValue(elContext);
                            if (fallback != null && fallback instanceof MethodExpression) {
                                return ((MethodExpression)fallback).invoke(elContext, objects);
                            }
                        }
                        catch (ELException ex) {
                            if (ex.getCause() != null && ex.getCause() instanceof ValidatorException) {
                                throw (ValidatorException)ex.getCause();
                            }
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, ele.toString());
                                LOGGER.log(Level.WARNING, "faces.facelets.el.method.expression.invoke.error: {0} {1}", new Object[]{ex.toString(), this.source.getExpressionString()});
                            }
                            if (ex instanceof MethodNotFoundException) break block14;
                            throw ex;
                        }
                    }
                }
                throw ele;
            }
        }
    }

    @Override
    public String getExpressionString() {
        return this.delegate.getExpressionString();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isLiteralText() {
        return this.delegate.isLiteralText();
    }

    private boolean pushCompositeComponent(FacesContext ctx) {
        ValueExpression orig;
        CompositeComponentStackManager manager = CompositeComponentStackManager.getManager(ctx);
        UIComponent foundCc = null;
        if (this.location != null) {
            foundCc = manager.findCompositeComponentUsingLocation(ctx, this.location);
        } else if (this.source instanceof TagValueExpression && (orig = ((TagValueExpression)this.source).getWrapped()) instanceof ContextualCompositeValueExpression) {
            foundCc = manager.findCompositeComponentUsingLocation(ctx, ((ContextualCompositeValueExpression)orig).getLocation());
        }
        if (null == foundCc) {
            foundCc = ctx.getViewRoot().findComponent(this.ccClientId);
        }
        return manager.push(foundCc);
    }

    private void popCompositeComponent(FacesContext ctx) {
        CompositeComponentStackManager manager = CompositeComponentStackManager.getManager(ctx);
        manager.pop();
    }

    private class SetClientIdListener
    implements ComponentSystemEventListener {
        private ContextualCompositeMethodExpression ccME;

        public SetClientIdListener(ContextualCompositeMethodExpression ccME) {
            this.ccME = ccME;
        }

        @Override
        public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
            this.ccME.ccClientId = event.getComponent().getClientId();
            event.getComponent().unsubscribeFromEvent(PostAddToViewEvent.class, this);
        }
    }
}

