/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.facelets.util.Classpath;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class MetaInfFaceletTaglibraryConfigProvider
implements ConfigurationResourceProvider {
    private static final String SUFFIX = ".taglib.xml";
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/META-INF";

    @Override
    public Collection<URI> getResources(ServletContext context) {
        try {
            ArrayList<URL> resourceURLs = new ArrayList<URL>(Arrays.asList(Classpath.search(Util.getCurrentLoader(this), "META-INF/", SUFFIX)));
            Set<String> paths = context.getResourcePaths(WEB_INF_CLASSES);
            if (paths != null) {
                for (String path : paths) {
                    if (!path.endsWith(SUFFIX)) continue;
                    resourceURLs.add(context.getResource(path));
                }
            }
            return resourceURLs.stream().map(url -> MetaInfFaceletTaglibraryConfigProvider.transformToURI(url)).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            throw new FacesException("Error searching classpath from facelet-taglib documents", ioe);
        }
    }

    private static URI transformToURI(URL url) {
        try {
            return new URI(url.toExternalForm().replace(" ", "%20"));
        }
        catch (URISyntaxException ex) {
            throw new FacesException(ex);
        }
    }
}

