/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cdi;

import com.sun.faces.cdi.CdiProducer;
import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.cdi.ParameterizedTypeImpl;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.annotation.ManagedProperty;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class ManagedPropertyProducer
extends CdiProducer<Object> {
    private static final long serialVersionUID = 1L;
    private Class<?> expectedClass;

    public ManagedPropertyProducer(Type type2, BeanManager beanManager) {
        super.qualifiers(ManagedProperty.Literal.INSTANCE).beanClass(beanManager, ManagedPropertyProducer.class).types(type2).addToId(type2).create((CreationalContext<T> creationalContext) -> {
            String expression = CdiUtils.getCurrentInjectionPoint(beanManager, creationalContext).getAnnotated().getAnnotation(ManagedProperty.class).value();
            return ManagedPropertyProducer.evaluateExpressionGet(beanManager, expression, this.expectedClass);
        });
        this.expectedClass = ManagedPropertyProducer.getExpectedClass(type2);
    }

    private static Class<?> getExpectedClass(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedTypeImpl) {
            return ManagedPropertyProducer.getExpectedClass(((ParameterizedTypeImpl)type2).getRawType());
        }
        return Object.class;
    }

    public static <T> T evaluateExpressionGet(BeanManager beanManager, String expression, Class<T> expectedClass) {
        if (expression == null) {
            return null;
        }
        FacesContext context = CdiUtils.getBeanReference(beanManager, FacesContext.class, new Annotation[0]);
        return context.getApplication().evaluateExpressionGet(context, expression, expectedClass);
    }
}

