/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.web.MemoryStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.web.LogFacade;

public class PersistenceStrategyBuilderFactory {
    private static final Logger _logger = LogFacade.getLogger();
    ServiceLocator services;

    public PersistenceStrategyBuilderFactory(ServerConfigLookup serverConfigLookup, ServiceLocator services) {
        this.services = services;
    }

    public PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope, Context ctx) {
        PersistenceStrategyBuilder builder;
        String resolvedPersistenceFrequency = null;
        String resolvedPersistenceScope = null;
        if (!(persistenceType.equalsIgnoreCase(PersistenceType.MEMORY.getType()) || persistenceType.equalsIgnoreCase(PersistenceType.FILE.getType()) || persistenceType.equalsIgnoreCase(PersistenceType.COOKIE.getType()))) {
            resolvedPersistenceFrequency = frequency;
            resolvedPersistenceScope = scope;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "AS-WEB-GLUE-00108", new Object[]{persistenceType, resolvedPersistenceFrequency, resolvedPersistenceScope});
        }
        if ((builder = this.services.getService(PersistenceStrategyBuilder.class, persistenceType, new Annotation[0])) == null) {
            builder = new MemoryStrategyBuilder();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "AS-WEB-GLUE-00109", persistenceType);
            }
        } else {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "AS-WEB-GLUE-00110", builder.getClass());
            }
            builder.setPersistenceFrequency(frequency);
            builder.setPersistenceScope(scope);
            builder.setPassedInPersistenceType(persistenceType);
        }
        return builder;
    }

    public String getApplicationId(Context ctx) {
        if (ctx instanceof WebModule) {
            return ((WebModule)ctx).getID();
        }
        return ctx.getName();
    }
}

