/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.web.BasePersistenceStrategyBuilder;
import com.sun.enterprise.web.PESessionLocker;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.session.PersistenceType;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.apache.catalina.Context;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardManager;
import org.glassfish.web.deployment.runtime.SessionManager;
import org.jvnet.hk2.annotations.Service;

@Service(name="memory")
public class MemoryStrategyBuilder
extends BasePersistenceStrategyBuilder {
    @Override
    public void initializePersistenceStrategy(Context ctx, SessionManager smBean, ServerConfigLookup serverConfigLookup) {
        super.initializePersistenceStrategy(ctx, smBean, serverConfigLookup);
        String persistenceType = PersistenceType.MEMORY.getType();
        String ctxPath = ctx.getPath();
        if (ctxPath != null && !ctxPath.equals("") && _logger.isLoggable(Level.FINE)) {
            Object[] params = new Object[]{ctx.getPath(), persistenceType};
            _logger.log(Level.FINE, "AS-WEB-GLUE-00096", params);
        }
        StandardManager mgr = new StandardManager();
        if (this.sessionFilename == null) {
            mgr.setPathname(this.sessionFilename);
        } else {
            mgr.setPathname(this.prependContextPathTo(this.sessionFilename, ctx));
        }
        mgr.setMaxActiveSessions(this.maxSessions);
        mgr.setSessionLocker(new PESessionLocker(ctx));
        ctx.setManager(mgr);
        if (this.sessionIdGeneratorClassname != null && this.sessionIdGeneratorClassname.length() > 0) {
            try {
                UuidGenerator generator = (UuidGenerator)serverConfigLookup.loadClass(this.sessionIdGeneratorClassname).newInstance();
                mgr.setUuidGenerator(generator);
            }
            catch (Exception ex) {
                String msg = _rb.getString("AS-WEB-GLUE-00097");
                msg = MessageFormat.format(msg, this.sessionIdGeneratorClassname);
                _logger.log(Level.SEVERE, msg, ex);
            }
        }
        if (!((StandardContext)ctx).isSessionTimeoutOveridden()) {
            mgr.setMaxInactiveInterval(this.sessionMaxInactiveInterval);
        }
    }
}

