/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.web.WebModule;
import jakarta.annotation.security.DeclareRoles;
import jakarta.annotation.security.RunAs;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.ServletSecurity;
import java.util.HashSet;
import java.util.Set;
import org.apache.catalina.core.DynamicServletRegistrationImpl;
import org.apache.catalina.core.StandardWrapper;
import org.glassfish.security.common.Role;
import org.glassfish.web.deployment.annotation.handlers.ServletSecurityHandler;
import org.glassfish.web.deployment.descriptor.WebComponentDescriptorImpl;

class DynamicWebServletRegistrationImpl
extends DynamicServletRegistrationImpl {
    private final WebBundleDescriptor webBundleDescriptor;
    private WebComponentDescriptor webComponentDescriptor;
    private final WebModule webModule;
    private String runAsRoleName;
    private ServletSecurityElement servletSecurityElement;

    public DynamicWebServletRegistrationImpl(StandardWrapper wrapper, WebModule webModule) {
        super(wrapper, webModule);
        this.webModule = webModule;
        this.webBundleDescriptor = webModule.getWebBundleDescriptor();
        if (this.webBundleDescriptor == null) {
            throw new IllegalStateException("Missing WebBundleDescriptor for " + this.getContext().getName());
        }
        this.webBundleDescriptor.setPolicyModified(true);
        this.webComponentDescriptor = this.webBundleDescriptor.getWebComponentByCanonicalName(wrapper.getName());
        if (this.webComponentDescriptor == null) {
            this.webComponentDescriptor = new WebComponentDescriptorImpl();
            this.webComponentDescriptor.setName(wrapper.getName());
            this.webComponentDescriptor.setCanonicalName(wrapper.getName());
            this.webBundleDescriptor.addWebComponentDescriptor(this.webComponentDescriptor);
            String servletClassName = wrapper.getServletClassName();
            if (servletClassName != null) {
                Class<Servlet> clazz = wrapper.getServletClass();
                if (clazz == null) {
                    if (wrapper.getServlet() != null) {
                        clazz = wrapper.getServlet().getClass();
                    } else {
                        try {
                            clazz = this.loadServletClass(servletClassName);
                        }
                        catch (Exception ex) {
                            throw new IllegalArgumentException(ex);
                        }
                    }
                    wrapper.setServletClass(clazz);
                }
                this.processServletAnnotations(clazz, this.webBundleDescriptor, this.webComponentDescriptor, wrapper);
            } else if (wrapper.getJspFile() == null) {
                throw new RuntimeException("Programmatic servlet registration without any supporting servlet class or jsp file");
            }
        }
    }

    @Override
    public Set<String> addMapping(String ... urlPatterns) {
        Set<String> conflicts = super.addMapping(urlPatterns);
        if (conflicts.isEmpty() && urlPatterns != null && urlPatterns.length > 0) {
            for (String urlPattern : urlPatterns) {
                this.webComponentDescriptor.addUrlPattern(urlPattern);
            }
        }
        return conflicts;
    }

    @Override
    public void setRunAsRole(String roleName) {
        super.setRunAsRole(roleName);
        this.runAsRoleName = roleName;
    }

    @Override
    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        this.servletSecurityElement = constraint;
        HashSet<String> conflictUrls = new HashSet<String>(this.webComponentDescriptor.getUrlPatternsSet());
        conflictUrls.removeAll(ServletSecurityHandler.getUrlPatternsWithoutSecurityConstraint(this.webComponentDescriptor));
        conflictUrls.addAll(super.setServletSecurity(constraint));
        return conflictUrls;
    }

    @Override
    protected void setServletClassName(String className) {
        super.setServletClassName(className);
        try {
            Class<? extends Servlet> clazz = this.loadServletClass(className);
            super.setServletClass(clazz);
            this.processServletAnnotations(clazz, this.webBundleDescriptor, this.webComponentDescriptor, this.wrapper);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    protected void setServletClass(Class<? extends Servlet> clazz) {
        super.setServletClass(clazz);
        this.processServletAnnotations(clazz, this.webBundleDescriptor, this.webComponentDescriptor, this.wrapper);
    }

    private void processServletAnnotations(Class<? extends Servlet> clazz, WebBundleDescriptor webBundleDescriptor, WebComponentDescriptor wcd, StandardWrapper wrapper) {
        if (clazz.isAnnotationPresent(DeclareRoles.class)) {
            DeclareRoles declareRoles = clazz.getAnnotation(DeclareRoles.class);
            for (String roleName : declareRoles.value()) {
                webBundleDescriptor.addRole(new Role(roleName));
                this.webModule.declareRoles(roleName);
            }
        }
        if (clazz.isAnnotationPresent(MultipartConfig.class)) {
            MultipartConfig mpConfig = clazz.getAnnotation(MultipartConfig.class);
            wrapper.setMultipartLocation(mpConfig.location());
            wrapper.setMultipartMaxFileSize(mpConfig.maxFileSize());
            wrapper.setMultipartMaxRequestSize(mpConfig.maxRequestSize());
            wrapper.setMultipartFileSizeThreshold(mpConfig.fileSizeThreshold());
        }
    }

    void postProcessAnnotations() {
        Class<? extends Servlet> clazz = this.wrapper.getServletClass();
        if (clazz == null) {
            return;
        }
        if (this.webComponentDescriptor.getRunAsIdentity() == null) {
            String roleName = this.runAsRoleName;
            if (roleName == null && clazz.isAnnotationPresent(RunAs.class)) {
                RunAs runAs = clazz.getAnnotation(RunAs.class);
                roleName = runAs.value();
            }
            if (roleName != null) {
                super.setRunAsRole(roleName);
                this.webBundleDescriptor.addRole(new Role(roleName));
                RunAsIdentityDescriptor runAsDesc = new RunAsIdentityDescriptor();
                runAsDesc.setRoleName(roleName);
                this.webComponentDescriptor.setRunAsIdentity(runAsDesc);
            }
        }
        ServletSecurityElement ssElement = this.servletSecurityElement;
        if (this.servletSecurityElement == null && clazz.isAnnotationPresent(ServletSecurity.class)) {
            ServletSecurity servletSecurity = clazz.getAnnotation(ServletSecurity.class);
            ssElement = new ServletSecurityElement(servletSecurity);
        }
        if (ssElement != null) {
            this.webModule.processServletSecurityElement(ssElement, this.webBundleDescriptor, this.webComponentDescriptor);
        }
    }

    private Class<? extends Servlet> loadServletClass(String className) throws ClassNotFoundException {
        return this.ctx.getLoader().getClassLoader().loadClass(className);
    }
}

